/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.base;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;

public class VersionControl {
    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(String name, Class<T> type, Class<?> ... parameterTypes) {
        return VersionControl.getConstructor(VersionControl.chooseClassBasedOnVersion(name, type), parameterTypes);
    }

    public static <T> T createObject(String name, Class<T> type, Class<?> parameterTypes, Object parameter) {
        Class<T> path = VersionControl.chooseClassBasedOnVersion(name, type);
        try {
            return path.getConstructor(parameterTypes).newInstance(parameter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T createObject(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createObject(String name) {
        return VersionControl.createObject(name, Object.class);
    }

    public static <T> T createObject(String name, Class<T> type) {
        return VersionControl.createObject(VersionControl.chooseClassBasedOnVersion(name, type));
    }

    public static <T> T createObject(Class<T> path) {
        try {
            return path.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Class<T> forName(String path, Class<T> type) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Class<T> chooseClassBasedOnVersion(String name, Class<T> type) {
        String path;
        Class<T> clazz;
        int index = VersionControl.getIndex();
        while ((clazz = VersionControl.forName(path = String.format("%s.%s", VersionControl.getDirectionBaseOnVersion(index--), name), type)) == null && index >= 0) {
        }
        return clazz;
    }

    public static Class chooseClassBasedOnVersion(String name) {
        return VersionControl.chooseClassBasedOnVersion(name, Object.class);
    }

    public static int getIndex() {
        switch ("1.9.4") {
            case "1.8.9": {
                return 0;
            }
            case "1.9.4": {
                return 1;
            }
            case "1.10.2": {
                return 2;
            }
            case "1.11.2": {
                return 3;
            }
            case "1.12": 
            case "1.12.1": 
            case "1.12.2": {
                return 4;
            }
        }
        return 5;
    }

    public static String getDirectionBaseOnVersion(int index) {
        switch (index) {
            case 0: {
                return "doggytalents.base.b";
            }
            case 1: {
                return "doggytalents.base.c";
            }
            case 2: {
                return "doggytalents.base.d";
            }
            case 3: {
                return "doggytalents.base.e";
            }
            case 4: {
                return "doggytalents.base.f";
            }
        }
        return "doggytalents.base";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface VersionConfig {
        public String[] value() default {""};
    }
}

