/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.blocks.BlockDecorCraftingTable;
import wile.engineersdecor.blocks.BlockDecorDropper;
import wile.engineersdecor.blocks.BlockDecorFurnace;
import wile.engineersdecor.blocks.BlockDecorFurnaceElectrical;
import wile.engineersdecor.blocks.BlockDecorLadder;
import wile.engineersdecor.blocks.BlockDecorWasteIncinerator;
import wile.engineersdecor.blocks.ModBlocks;
import wile.engineersdecor.detail.ModConfig;
import wile.engineersdecor.detail.Networking;
import wile.engineersdecor.detail.RecipeCondModSpecific;

@Mod(value="engineersdecor")
public class ModEngineersDecor {
    public static final String MODID = "engineersdecor";
    private static final Logger LOGGER = LogManager.getLogger();
    public static ISidedProxy proxy = (ISidedProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabengineersdecor"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModBlocks.SIGN_MODLOGO);
        }
    };

    public ModEngineersDecor() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSendImc);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRecvImc);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> GuiHandlers::openGui);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.conf_spec);
        LOGGER.info("Registering recipe condition processor ...");
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "grc"), (IConditionSerializer)new RecipeCondModSpecific());
        Networking.init();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
    }

    private void onSendImc(InterModEnqueueEvent event) {
    }

    private void onRecvImc(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.field_70170_p == null) {
            return;
        }
        if (player.func_70617_f_()) {
            BlockDecorLadder.onPlayerUpdateEvent(player);
        }
    }

    public static final class GuiHandlers {
        @OnlyIn(value=Dist.CLIENT)
        public static GuiScreen openGui(FMLPlayMessages.OpenContainer container) {
            BlockPos pos = container.getAdditionalData().func_179259_c();
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (container.getId().equals((Object)ModBlocks.TREATED_WOOD_CRAFTING_TABLE.getRegistryName())) {
                if (!(te instanceof BlockDecorCraftingTable.BTileEntity)) {
                    return null;
                }
                return new BlockDecorCraftingTable.BGui(player.field_71071_by, (World)world, pos, (BlockDecorCraftingTable.BTileEntity)te);
            }
            if (container.getId().equals((Object)ModBlocks.SMALL_LAB_FURNACE.getRegistryName())) {
                if (!(te instanceof BlockDecorFurnace.BTileEntity)) {
                    return null;
                }
                return new BlockDecorFurnace.BGui(player.field_71071_by, (World)world, pos, (BlockDecorFurnace.BTileEntity)te);
            }
            if (container.getId().equals((Object)ModBlocks.SMALL_ELECTRICAL_FURNACE.getRegistryName())) {
                if (!(te instanceof BlockDecorFurnaceElectrical.BTileEntity)) {
                    return null;
                }
                return new BlockDecorFurnaceElectrical.BGui(player.field_71071_by, (World)world, pos, (BlockDecorFurnaceElectrical.BTileEntity)te);
            }
            if (container.getId().equals((Object)ModBlocks.FACTORY_DROPPER.getRegistryName())) {
                if (!(te instanceof BlockDecorDropper.BTileEntity)) {
                    return null;
                }
                return new BlockDecorDropper.BGui(player.field_71071_by, (World)world, pos, (BlockDecorDropper.BTileEntity)te);
            }
            if (container.getId().equals((Object)ModBlocks.SMALL_WASTE_INCINERATOR.getRegistryName())) {
                if (!(te instanceof BlockDecorWasteIncinerator.BTileEntity)) {
                    return null;
                }
                return new BlockDecorWasteIncinerator.BGui(player.field_71071_by, (World)world, pos, (BlockDecorWasteIncinerator.BTileEntity)te);
            }
            return null;
        }
    }

    public static final class ServerProxy
    implements ISidedProxy {
        @Override
        @Nullable
        public World getWorlClientSide() {
            return null;
        }
    }

    public static final class ClientProxy
    implements ISidedProxy {
        @Override
        @Nullable
        public World getWorlClientSide() {
            return Minecraft.func_71410_x().field_71441_e;
        }
    }

    public static interface ISidedProxy {
        @Nullable
        default public World getWorlClientSide() {
            return null;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModBlocks.registerBlocks(event);
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModBlocks.registerItemBlocks(event);
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModBlocks.registerTileEntities(event);
        }

        @SubscribeEvent
        public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
            ModBlocks.registerEntities(event);
        }
    }
}

