/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecor
extends Block {
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_HORIZIONTAL = 2L;
    public static final long CFG_LOOK_PLACEMENT = 4L;
    public static final long CFG_FACING_PLACEMENT = 8L;
    public static final long CFG_OPPOSITE_PLACEMENT = 16L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 32L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 64L;
    public static final long CFG_TRANSLUCENT = 128L;
    public static final long CFG_LIGHT_VALUE_MASK = 3840L;
    public static final long CFG_LIGHT_VALUE_SHIFT = 8L;
    public static final long CFG_ELECTRICAL = 65536L;
    public static final long CFG_REDSTONE_CONTROLLED = 131072L;
    public static final long CFG_ANALOG = 262144L;
    public final long config;
    public final VoxelShape vshape;

    public BlockDecor(long config, Block.Properties properties) {
        this(config, properties, ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
    }

    public BlockDecor(long config, Block.Properties properties, AxisAlignedBB aabb) {
        super(properties);
        this.config = config;
        this.vshape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
    }

    public BlockDecor(long config, Block.Properties properties, VoxelShape voxel_shape) {
        super(properties);
        this.config = config;
        this.vshape = voxel_shape;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return (this.config & 1L) != 0L ? BlockRenderLayer.CUTOUT : BlockRenderLayer.SOLID;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        return this.vshape;
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.vshape;
    }

    public boolean func_149686_d(IBlockState state) {
        return (this.config & 1L) == 0L;
    }

    public boolean func_149721_r(IBlockState state) {
        return (this.config & 1L) == 0L;
    }

    public boolean func_181623_g() {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public int func_149750_m(IBlockState state) {
        return (int)((this.config & 0xF00L) >> 8);
    }
}

