/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.blocks.ModBlocks;

public class BlockDecorChair
extends BlockDecorDirected {
    private static boolean sitting_enabled = true;
    private static double sitting_probability = 0.1;
    private static double standup_probability = 0.01;

    public static void on_config(boolean without_sitting, boolean without_mob_sitting, double sitting_probability_percent, double standup_probability_percent) {
        sitting_enabled = !without_sitting;
        sitting_probability = without_sitting || without_mob_sitting ? 0.0 : MathHelper.func_151237_a((double)(sitting_probability_percent / 100.0), (double)0.0, (double)0.9);
        standup_probability = without_sitting || without_mob_sitting ? 1.0 : MathHelper.func_151237_a((double)(standup_probability_percent / 100.0), (double)1.0E-6, (double)0.01);
        ModEngineersDecor.logger().info("Config chairs: " + sitting_enabled + ", sit: " + sitting_probability, (Object)(", stand up: " + standup_probability));
    }

    public BlockDecorChair(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config, builder.func_200944_c(), unrotatedAABB);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (sitting_enabled && !world.field_72995_K) {
            EntityChair.sit(world, (EntityLivingBase)player, pos);
        }
        return true;
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (sitting_enabled && Math.random() < sitting_probability && entity instanceof EntityMob) {
            EntityChair.sit(world, (EntityLivingBase)entity, pos);
        }
    }

    public int func_149738_a(IWorldReaderBase world) {
        return 10;
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (!sitting_enabled || sitting_probability < 1.0E-6) {
            return;
        }
        List entities = world.func_72872_a(EntityMob.class, new AxisAlignedBB(pos).func_72314_b(2.0, 1.0, 2.0).func_72321_a(0.0, 1.0, 0.0));
        if (entities.isEmpty()) {
            return;
        }
        int index = rnd.nextInt(entities.size());
        if (index < 0 || index >= entities.size()) {
            return;
        }
        EntityChair.sit(world, (EntityLivingBase)entities.get(index), pos);
    }

    public static class EntityChair
    extends Entity {
        public final double x_offset = 0.5;
        public final double y_offset = 0.4;
        public final double z_offset = 0.5;
        private int t_tick = 0;
        private int t_sit = 0;
        public BlockPos chair_pos = new BlockPos(0, 0, 0);

        EntityChair(World world) {
            super(ModBlocks.ET_CHAIR, world);
            this.field_70156_m = true;
            this.field_70145_X = true;
            this.func_70105_a(0.002f, 0.002f);
        }

        EntityChair(EntityType<?> entityType, World world) {
            super(entityType, world);
            this.field_70156_m = true;
            this.field_70145_X = true;
            this.func_70105_a(0.002f, 0.002f);
        }

        public EntityChair(World world, BlockPos pos) {
            this(ModBlocks.ET_CHAIR, world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5);
            this.chair_pos = pos;
            this.t_sit = 5;
        }

        public static boolean accepts_mob(EntityLivingBase entity) {
            if (!(entity instanceof EntityMob)) {
                return false;
            }
            if ((double)entity.field_70131_O > 2.5 || (double)entity.field_70130_N > 2.0) {
                return false;
            }
            if (entity instanceof EntityZombie) {
                return true;
            }
            if (entity instanceof EntityZombieVillager) {
                return true;
            }
            if (entity instanceof EntityPigZombie) {
                return true;
            }
            if (entity instanceof EntityHusk) {
                return true;
            }
            if (entity instanceof EntityStray) {
                return true;
            }
            if (entity instanceof EntitySkeleton) {
                return true;
            }
            return entity instanceof EntityWitherSkeleton;
        }

        public static void sit(World world, EntityLivingBase sitter, BlockPos pos) {
            if (!sitting_enabled) {
                return;
            }
            if (world == null || world.field_72995_K || sitter == null || pos == null) {
                return;
            }
            if (!(sitter instanceof EntityPlayer) && !EntityChair.accepts_mob(sitter)) {
                return;
            }
            if (!world.func_72872_a(EntityChair.class, new AxisAlignedBB(pos)).isEmpty()) {
                return;
            }
            if (sitter.func_184207_aI() || !sitter.func_70089_S() || sitter.func_184218_aH()) {
                return;
            }
            if (!world.func_175623_d(pos.func_177984_a()) || !world.func_175623_d(pos.func_177981_b(2))) {
                return;
            }
            EntityChair chair = new EntityChair(world, pos);
            if (world.func_72838_d((Entity)chair)) {
                sitter.func_184220_m((Entity)chair);
            }
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public double func_70042_X() {
            return 0.0;
        }

        public void func_70071_h_() {
            Entity sitter;
            if (this.field_70170_p.field_72995_K || --this.t_tick > 0) {
                return;
            }
            this.t_tick = 20;
            if (--this.t_sit > 0) {
                return;
            }
            Entity entity = sitter = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (sitter == null || !sitter.func_70089_S()) {
                this.func_70106_y();
                return;
            }
            boolean abort = !sitting_enabled;
            IBlockState state = this.field_70170_p.func_180495_p(this.chair_pos);
            if (state == null || !(state.func_177230_c() instanceof BlockDecorChair)) {
                abort = true;
            }
            if (!this.field_70170_p.func_175623_d(this.chair_pos.func_177984_a())) {
                abort = true;
            }
            if (!(sitter instanceof EntityPlayer) && Math.random() < standup_probability) {
                abort = true;
            }
            if (abort) {
                for (Entity e : this.func_184188_bt()) {
                    if (!e.func_70089_S()) continue;
                    e.func_184210_p();
                }
                this.func_70106_y();
            }
        }
    }
}

