/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.blocks.ModBlocks;
import wile.engineersdecor.detail.Networking;

public class BlockDecorCraftingTable
extends BlockDecorDirected {
    public static boolean with_assist = true;
    public static boolean with_assist_direct_history_refab = false;
    public static boolean with_assist_quickmove_buttons = false;

    public static final void on_config(boolean without_crafting_assist, boolean with_assist_immediate_history_refab, boolean with_quickmove_buttons) {
        with_assist = !without_crafting_assist;
        with_assist_direct_history_refab = with_assist_immediate_history_refab;
        with_assist_quickmove_buttons = with_quickmove_buttons;
        CraftingHistory.max_history_size(32);
    }

    public BlockDecorCraftingTable(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config, builder, unrotatedAABB);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new BTileEntity();
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        if (!(player instanceof EntityPlayerMP) && !(player instanceof FakePlayer)) {
            return true;
        }
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BInteraction(world, pos, (BTileEntity)te), buf -> buf.func_179255_a(pos));
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o()) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
            return;
        }
        NBTTagCompound inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
        if (inventory_nbt.isEmpty()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(inventory_nbt);
        ((BTileEntity)te).func_70296_d();
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BTileEntity)te));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private ItemStack itemize_with_inventory(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        NBTTagCompound inventory_nbt = new NBTTagCompound();
        ItemStackHelper.func_191281_a((NBTTagCompound)inventory_nbt, ((BTileEntity)te).stacks, (boolean)false);
        if (!inventory_nbt.isEmpty()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inventory", (INBTBase)inventory_nbt);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = this.itemize_with_inventory(world, pos);
        if (stack != ItemStack.field_190927_a) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
            world.func_175655_b(pos, false);
            world.func_175713_t(pos);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_176206_d(IWorld iworld, BlockPos pos, IBlockState state) {
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset();
        super.func_180652_a(world, pos, explosion);
    }

    public static class BTileEntity
    extends TileEntity
    implements IInventory,
    Networking.IPacketTileNotifyReceiver {
        public static final int CRAFTING_SLOTS_BEGIN = 0;
        public static final int NUM_OF_CRAFTING_SLOTS = 9;
        public static final int STORAGE_SLOTS_BEGIN = 9;
        public static final int NUM_OF_STORAGE_SLOTS = 8;
        public static final int NUM_OF_SLOTS = 17;
        protected NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
        protected final CraftingHistory history = new CraftingHistory();

        public BTileEntity() {
            this(ModBlocks.TET_TREATED_WOOD_CRAFTING_TABLE);
        }

        public BTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void reset() {
            this.stacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
        }

        public void readnbt(NBTTagCompound compound) {
            this.reset();
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
            while (this.stacks.size() < 17) {
                this.stacks.add((Object)ItemStack.field_190927_a);
            }
            this.history.read(compound);
        }

        private void writenbt(NBTTagCompound compound) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
            this.history.write(compound);
        }

        private boolean itemstack_recipe_match(ItemStack grid_stack, ItemStack history_stack) {
            if (this.history.current_recipe() != null) {
                for (Ingredient ingredient : this.history.current_recipe().func_192400_c()) {
                    boolean grid_match = false;
                    boolean dist_match = false;
                    for (ItemStack match : ingredient.func_193365_a()) {
                        if (match.func_185136_b(grid_stack)) {
                            dist_match = true;
                        }
                        if (match.func_185136_b(history_stack)) {
                            grid_match = true;
                        }
                        if (!dist_match || !grid_match) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private List<ItemStack> crafting_slot_stacks_to_add() {
            int i;
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
            List<ItemStack> tocraft = this.history.current();
            int[] stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            if (tocraft.isEmpty()) {
                return slots;
            }
            for (int i2 = 0; i2 < 9 && i2 + 1 < tocraft.size(); ++i2) {
                ItemStack needed = tocraft.get(i2 + 1);
                ItemStack palced = this.func_70301_a(i2 + 0);
                if (needed.func_190926_b() && !palced.func_190926_b()) {
                    return slots;
                }
                if (!palced.func_190926_b() && !this.itemstack_recipe_match(needed, palced)) {
                    return slots;
                }
                if (needed.func_190926_b()) continue;
                stack_sizes[i2] = palced.func_190916_E();
            }
            int min_placed = 64;
            int max_placed = 0;
            for (int i3 = 0; i3 < 9; ++i3) {
                if (stack_sizes[i3] < 0) continue;
                min_placed = Math.min(min_placed, stack_sizes[i3]);
                max_placed = Math.max(max_placed, stack_sizes[i3]);
            }
            int fillup_size = max_placed <= min_placed ? min_placed + 1 : max_placed;
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0 || fillup_size <= this.func_70301_a(i + 0).func_77976_d()) continue;
                return slots;
            }
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0) {
                    slots.add(ItemStack.field_190927_a);
                    continue;
                }
                ItemStack st = this.func_70301_a(i + 0).func_77946_l();
                if (st.func_190926_b()) {
                    st = tocraft.get(i + 1).func_77946_l();
                    st.func_190920_e(Math.min(st.func_77976_d(), fillup_size));
                } else {
                    st.func_190920_e(MathHelper.func_76125_a((int)(fillup_size - st.func_190916_E()), (int)0, (int)st.func_77976_d()));
                }
                slots.add(st);
            }
            return slots;
        }

        private ItemStack move_stack_to_inventory(ItemStack stack_to_move, IInventory inventory, int slot_begin, int slot_end, boolean only_fillup) {
            ItemStack stack;
            int i;
            ItemStack mvstack = stack_to_move.func_77946_l();
            if (mvstack.func_190926_b() || slot_begin < 0 || slot_end > inventory.func_70302_i_()) {
                return mvstack;
            }
            for (i = slot_begin; i < slot_end; ++i) {
                stack = inventory.func_70301_a(i);
                if (stack.func_190926_b() || !stack.func_77969_a(mvstack)) continue;
                int nmax = stack.func_77976_d() - stack.func_190916_E();
                if (mvstack.func_190916_E() <= nmax) {
                    stack.func_190920_e(stack.func_190916_E() + mvstack.func_190916_E());
                    mvstack.func_190920_e(0);
                    inventory.func_70299_a(i, stack);
                    return mvstack;
                }
                stack.func_190920_e(stack.func_77976_d());
                mvstack.func_190918_g(nmax);
                inventory.func_70299_a(i, stack);
            }
            if (only_fillup) {
                return mvstack;
            }
            if (inventory instanceof InventoryPlayer) {
                for (i = slot_begin + 1; i < slot_end - 1; ++i) {
                    stack = inventory.func_70301_a(i);
                    if (!stack.func_190926_b() || !inventory.func_70301_a(i + 1).func_77969_a(mvstack) && !inventory.func_70301_a(i - 1).func_77969_a(mvstack)) continue;
                    inventory.func_70299_a(i, mvstack.func_77946_l());
                    mvstack.func_190920_e(0);
                    return mvstack;
                }
            }
            for (i = slot_begin; i < slot_end; ++i) {
                stack = inventory.func_70301_a(i);
                if (!stack.func_190926_b()) continue;
                inventory.func_70299_a(i, mvstack.func_77946_l());
                mvstack.func_190920_e(0);
                return mvstack;
            }
            return mvstack;
        }

        private ItemStack move_stack_from_inventory(IInventory inventory, ItemStack request_stack, int slot_begin, int slot_end) {
            int n;
            ItemStack fetched_stack = request_stack.func_77946_l();
            fetched_stack.func_190920_e(0);
            for (int n_left = request_stack.func_190916_E(); n_left > 0; n_left -= n) {
                int smallest_stack_size = 0;
                int smallest_stack_index = -1;
                for (int i = slot_begin; i < slot_end; ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b() || !stack.func_77969_a(request_stack)) continue;
                    if (stack.func_77942_o()) {
                        NBTTagCompound nbt = stack.func_77978_p();
                        int n2 = stack.func_77978_p().func_186856_d();
                        if (n2 > 0 && stack.func_77978_p().func_74764_b("Damage")) {
                            --n2;
                        }
                        if (n2 > 0) continue;
                    }
                    fetched_stack = stack.func_77946_l();
                    fetched_stack.func_190920_e(0);
                    int n3 = stack.func_190916_E();
                    if (n3 >= smallest_stack_size && smallest_stack_size > 0) continue;
                    smallest_stack_size = n3;
                    smallest_stack_index = i;
                }
                if (smallest_stack_index < 0) break;
                n = Math.min(n_left, smallest_stack_size);
                fetched_stack.func_190917_f(n);
                ItemStack st = inventory.func_70301_a(smallest_stack_index);
                st.func_190918_g(n);
                inventory.func_70299_a(smallest_stack_index, st);
            }
            return fetched_stack;
        }

        private boolean clear_grid_to_storage(EntityPlayer player) {
            boolean changed = false;
            for (int grid_i = 0; grid_i < 9; ++grid_i) {
                ItemStack stack = this.func_70301_a(grid_i);
                if (stack.func_190926_b()) continue;
                ItemStack remaining = this.move_stack_to_inventory(stack, this, 9, 17, false);
                this.func_70299_a(grid_i, remaining);
                changed = true;
            }
            return changed;
        }

        private boolean clear_grid_to_player(EntityPlayer player) {
            boolean changed = false;
            for (int grid_i = 0; grid_i < 9; ++grid_i) {
                ItemStack remaining = this.func_70301_a(grid_i);
                if (remaining.func_190926_b()) continue;
                remaining = this.move_stack_to_inventory(remaining, (IInventory)player.field_71071_by, 9, 36, true);
                remaining = this.move_stack_to_inventory(remaining, (IInventory)player.field_71071_by, 0, 9, true);
                remaining = this.move_stack_to_inventory(remaining, (IInventory)player.field_71071_by, 9, 36, false);
                remaining = this.move_stack_to_inventory(remaining, (IInventory)player.field_71071_by, 0, 9, false);
                this.func_70299_a(grid_i, remaining);
                changed = true;
            }
            return changed;
        }

        private EnumRefabPlacement place_refab_stacks(IInventory inventory, int slot_begin, int slot_end) {
            List<ItemStack> to_fill = this.crafting_slot_stacks_to_add();
            boolean slots_changed = false;
            boolean missing_item = false;
            boolean num_slots_placed = false;
            if (!to_fill.isEmpty()) {
                for (int it_guard = 63; it_guard >= 0; --it_guard) {
                    boolean slots_updated = false;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack req_stack = to_fill.get(i).func_77946_l();
                        if (req_stack.func_190926_b()) continue;
                        req_stack.func_190920_e(1);
                        to_fill.get(i).func_190918_g(1);
                        ItemStack mv_stack = this.move_stack_from_inventory(inventory, req_stack, slot_begin, slot_end);
                        if (mv_stack.func_190926_b()) {
                            missing_item = true;
                            continue;
                        }
                        ItemStack grid_stack = this.func_70301_a(i + 0).func_77946_l();
                        if (grid_stack.func_190926_b()) {
                            grid_stack = mv_stack.func_77946_l();
                        } else {
                            grid_stack.func_190917_f(mv_stack.func_190916_E());
                        }
                        this.func_70299_a(i + 0, grid_stack);
                        slots_changed = true;
                        slots_updated = true;
                    }
                    if (!slots_updated) break;
                }
            }
            if (!slots_changed) {
                return EnumRefabPlacement.UNCHANGED;
            }
            if (missing_item) {
                return EnumRefabPlacement.INCOMPLETE;
            }
            return EnumRefabPlacement.PLACED;
        }

        private EnumRefabPlacement distribute_stack(IInventory inventory, int slotno) {
            List<ItemStack> to_refab = this.crafting_slot_stacks_to_add();
            ItemStack to_distribute = inventory.func_70301_a(slotno).func_77946_l();
            if (to_distribute.func_190926_b()) {
                return EnumRefabPlacement.UNCHANGED;
            }
            int[] matching_grid_stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            int max_matching_stack_size = -1;
            int min_matching_stack_size = 65;
            int total_num_missing_stacks = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack refab_stack;
                ItemStack grid_stack = this.func_70301_a(i + 0);
                ItemStack itemStack = refab_stack = to_refab.isEmpty() ? ItemStack.field_190927_a : to_refab.get(i).func_77946_l();
                if (!grid_stack.func_190926_b() && grid_stack.func_77969_a(to_distribute)) {
                    matching_grid_stack_sizes[i] = grid_stack.func_190916_E();
                    total_num_missing_stacks += grid_stack.func_77976_d() - grid_stack.func_190916_E();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!refab_stack.func_190926_b() && refab_stack.func_77969_a(to_distribute)) {
                    matching_grid_stack_sizes[i] = 0;
                    total_num_missing_stacks += grid_stack.func_77976_d();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!grid_stack.func_190926_b() || refab_stack.func_190926_b() || !this.itemstack_recipe_match(to_distribute, refab_stack)) continue;
                matching_grid_stack_sizes[i] = 0;
                total_num_missing_stacks += grid_stack.func_77976_d();
                if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                    max_matching_stack_size = matching_grid_stack_sizes[i];
                }
                if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                min_matching_stack_size = matching_grid_stack_sizes[i];
            }
            if (min_matching_stack_size < 0) {
                return EnumRefabPlacement.UNCHANGED;
            }
            int stack_limit_size = Math.min(to_distribute.func_77976_d(), this.func_70297_j_());
            if (min_matching_stack_size >= stack_limit_size) {
                return EnumRefabPlacement.UNCHANGED;
            }
            int n_to_distribute = to_distribute.func_190916_E();
            for (int it_guard = 63; it_guard >= 0 && n_to_distribute > 0; --it_guard) {
                for (int i = 0; i < 9 && n_to_distribute > 0; ++i) {
                    if (matching_grid_stack_sizes[i] != min_matching_stack_size) continue;
                    int n = i;
                    matching_grid_stack_sizes[n] = matching_grid_stack_sizes[n] + 1;
                    --n_to_distribute;
                }
                if (min_matching_stack_size < max_matching_stack_size) {
                    ++min_matching_stack_size;
                } else {
                    max_matching_stack_size = ++min_matching_stack_size;
                }
                if (min_matching_stack_size >= stack_limit_size) break;
            }
            if (n_to_distribute == to_distribute.func_190916_E()) {
                return EnumRefabPlacement.UNCHANGED;
            }
            if (n_to_distribute <= 0) {
                inventory.func_70299_a(slotno, ItemStack.field_190927_a);
            } else {
                to_distribute.func_190920_e(n_to_distribute);
                inventory.func_70299_a(slotno, to_distribute);
            }
            for (int i = 0; i < 9; ++i) {
                if (matching_grid_stack_sizes[i] < 0) continue;
                ItemStack grid_stack = this.func_70301_a(i + 0).func_77946_l();
                if (grid_stack.func_190926_b()) {
                    grid_stack = to_distribute.func_77946_l();
                }
                grid_stack.func_190920_e(matching_grid_stack_sizes[i]);
                this.func_70299_a(i + 0, grid_stack);
            }
            return EnumRefabPlacement.PLACED;
        }

        @Override
        public void onServerPacketReceived(NBTTagCompound nbt) {
            if (nbt.func_74764_b("historydata")) {
                this.history.read(nbt.func_74775_l("historydata"));
            }
        }

        @Override
        public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
            if (this.field_145850_b.field_72995_K || !(player.field_71070_bA instanceof BContainer)) {
                return;
            }
            BContainer container = (BContainer)player.field_71070_bA;
            if (container.te != this) {
                return;
            }
            boolean te_changed = false;
            boolean player_inventory_changed = false;
            if (with_assist && nbt.func_74764_b("action")) {
                switch (nbt.func_74762_e("action")) {
                    case 0: {
                        this.history.next();
                        this.syncHistory(player);
                        if (this.clear_grid_to_player(player)) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 1: {
                        this.history.prev();
                        this.syncHistory(player);
                        if (this.clear_grid_to_player(player)) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 2: {
                        this.history.reset_selection();
                        this.syncHistory(player);
                        if (this.clear_grid_to_player(player)) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 4: {
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 6: {
                        if (!this.clear_grid_to_player(player)) break;
                        te_changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case 3: {
                        EnumRefabPlacement from_storage = this.place_refab_stacks(this, 9, 17);
                        if (from_storage == EnumRefabPlacement.UNCHANGED) break;
                        te_changed = true;
                        break;
                    }
                    case 5: {
                        EnumRefabPlacement from_hotbar;
                        EnumRefabPlacement from_player_inv = this.place_refab_stacks((IInventory)player.field_71071_by, 9, 36);
                        if (from_player_inv != EnumRefabPlacement.UNCHANGED) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (from_player_inv == EnumRefabPlacement.PLACED || (from_hotbar = this.place_refab_stacks((IInventory)player.field_71071_by, 0, 9)) == EnumRefabPlacement.UNCHANGED) break;
                        te_changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case 7: {
                        EnumRefabPlacement from_hotbar;
                        EnumRefabPlacement from_storage = this.place_refab_stacks(this, 9, 17);
                        if (from_storage != EnumRefabPlacement.UNCHANGED) {
                            te_changed = true;
                        }
                        if (from_storage == EnumRefabPlacement.PLACED) break;
                        EnumRefabPlacement from_player_inv = this.place_refab_stacks((IInventory)player.field_71071_by, 9, 36);
                        if (from_player_inv != EnumRefabPlacement.UNCHANGED) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (from_player_inv == EnumRefabPlacement.PLACED || (from_hotbar = this.place_refab_stacks((IInventory)player.field_71071_by, 0, 9)) == EnumRefabPlacement.UNCHANGED) break;
                        te_changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case 8: {
                        int container_slot_id = nbt.func_74762_e("containerslot");
                        if (container_slot_id < 10 || container_slot_id > 53) break;
                        if (container_slot_id >= 46) {
                            int storage_slot = container_slot_id - 46 + 9;
                            EnumRefabPlacement stat = this.distribute_stack(this, storage_slot);
                            if (stat == EnumRefabPlacement.UNCHANGED) break;
                            te_changed = true;
                            break;
                        }
                        int player_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                        EnumRefabPlacement stat = this.distribute_stack((IInventory)player.field_71071_by, player_slot);
                        if (stat == EnumRefabPlacement.UNCHANGED) break;
                        player_inventory_changed = true;
                        te_changed = true;
                    }
                }
            }
            if (te_changed) {
                this.func_70296_d();
            }
            if (player_inventory_changed) {
                player.field_71071_by.func_70296_d();
            }
            if (te_changed || player_inventory_changed) {
                container.func_75130_a(this);
                container.func_75142_b();
            }
        }

        private void syncHistory(EntityPlayer player) {
            if (!with_assist) {
                return;
            }
            NBTTagCompound history_nbt = new NBTTagCompound();
            this.history.write(history_nbt);
            NBTTagCompound rnbt = new NBTTagCompound();
            rnbt.func_74782_a("historydata", (INBTBase)history_nbt);
            Networking.PacketTileNotifyServerToClient.sendToPlayer(player, this, rnbt);
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.readnbt(compound);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            this.writenbt(compound);
            return compound;
        }

        public NBTTagCompound func_189517_E_() {
            NBTTagCompound nbt = super.func_189517_E_();
            this.writenbt(nbt);
            return nbt;
        }

        public void onLoad() {
            this.history.world = this.func_145831_w();
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return block != null ? block.func_200291_n() : new TextComponentString("Treated wood crafting table");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public int func_70302_i_() {
            return this.stacks.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks.set(index, (Object)stack);
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            this.stacks.clear();
        }

        static enum EnumRefabPlacement {
            UNCHANGED,
            INCOMPLETE,
            PLACED;

        }
    }

    public static class BInventoryCrafting
    extends InventoryCrafting {
        protected final Container container;
        protected final IInventory inventory;

        public BInventoryCrafting(Container container_, IInventory inventory_te) {
            super(container_, 3, 3);
            this.container = container_;
            this.inventory = inventory_te;
        }

        public int func_70302_i_() {
            return 9;
        }

        public void func_174889_b(EntityPlayer player) {
            this.inventory.func_174889_b(player);
        }

        public void func_174886_c(EntityPlayer player) {
            this.inventory.func_174886_c(player);
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(index, stack);
            this.container.func_75130_a((IInventory)this);
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = this.inventory.func_70298_a(index, count);
            if (!stack.func_190926_b()) {
                this.container.func_75130_a((IInventory)this);
            }
            return stack;
        }
    }

    public static class BContainer
    extends Container {
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        public BInventoryCrafting craftMatrix;
        public InventoryCraftResult craftResult = new InventoryCraftResult();
        public final ImmutableList<Tuple<Integer, Integer>> CRAFTING_SLOT_POSITIONS;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            int x;
            int y;
            ArrayList<Tuple> slotpositions = new ArrayList<Tuple>();
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            this.craftMatrix = new BInventoryCrafting(this, te);
            this.craftMatrix.func_174889_b(this.player);
            this.func_75146_a((Slot)new BSlotCrafting(te, playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 134, 35));
            slotpositions.add(new Tuple((Object)134, (Object)35));
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    int xpos = 60 + x * 18;
                    int ypos = 17 + y * 18;
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + y * 3, xpos, ypos));
                    slotpositions.add(new Tuple((Object)xpos, (Object)ypos));
                }
            }
            this.CRAFTING_SLOT_POSITIONS = ImmutableList.copyOf(slotpositions);
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x2, 8 + x2 * 18, 144));
            }
            for (y = 0; y < 4; ++y) {
                for (x = 0; x < 2; ++x) {
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + y * 2 + 9, 8 + x * 18, 9 + y * 18));
                }
            }
            this.func_75130_a((IInventory)this.craftMatrix);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorCraftingTable && player.func_174818_b(this.pos) <= 64.0;
        }

        public void func_75130_a(IInventory inv) {
            try {
                this.func_192389_a(this.world, this.player, (IInventory)this.craftMatrix, this.craftResult);
            }
            catch (Throwable exc) {
                ModEngineersDecor.logger().error("Recipe failed:", exc);
            }
        }

        public void func_75134_a(EntityPlayer player) {
            this.craftMatrix.func_174886_c(player);
            this.craftResult.func_174888_l();
            this.craftResult.func_174886_c(player);
            if (player != null) {
                for (Slot e : player.field_71069_bz.field_75151_b) {
                    if (!(e instanceof SlotCrafting)) continue;
                    ((SlotCrafting)e).func_75215_d(ItemStack.field_190927_a);
                }
            }
        }

        public boolean func_94530_a(ItemStack stack, Slot slot) {
            return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
        }

        public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slotstack = slot.func_75211_c();
            ItemStack stack = slotstack.func_77946_l();
            if (index == 0) {
                slotstack.func_77973_b().func_77622_d(slotstack, this.world, playerIn);
                if (!this.func_75135_a(slotstack, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotstack, stack);
            } else if (index >= 10 && index < 46 ? !this.func_75135_a(slotstack, 46, 54, false) : (index >= 46 && index < 54 ? !this.func_75135_a(slotstack, 10, 46, false) : !this.func_75135_a(slotstack, 10, 46, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotstack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotstack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, slotstack);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
            return stack;
        }
    }

    public static class BSlotCrafting
    extends SlotCrafting {
        private final BTileEntity te;
        private final EntityPlayer player;

        public BSlotCrafting(BTileEntity te, EntityPlayer player, InventoryCrafting craftingInventory, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
            super(player, craftingInventory, inventoryIn, slotIndex, xPosition, yPosition);
            this.te = te;
            this.player = player;
        }

        protected void func_75208_c(ItemStack stack) {
            if (with_assist && this.player.field_70170_p != null && !this.player.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                IRecipe recipe = ((InventoryCraftResult)this.field_75224_c).func_193055_i();
                ArrayList<ItemStack> grid = new ArrayList<ItemStack>();
                grid.add(stack);
                for (int i = 0; i < 9; ++i) {
                    grid.add((ItemStack)this.te.stacks.get(i));
                }
                this.te.history.add(grid, recipe);
                this.te.history.reset_current();
                this.te.syncHistory(this.player);
            }
            super.func_75208_c(stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BGui
    extends GuiContainer {
        protected static final int BUTTON_NEXT = 0;
        protected static final int BUTTON_PREV = 1;
        protected static final int BUTTON_CLEAR_GRID = 2;
        protected static final int BUTTON_FROM_STORAGE = 3;
        protected static final int BUTTON_TO_STORAGE = 4;
        protected static final int BUTTON_FROM_PLAYER = 5;
        protected static final int BUTTON_TO_PLAYER = 6;
        protected static final int ACTION_PLACE_CURRENT_HISTORY_SEL = 7;
        protected static final int ACTION_PLACE_SHIFTCLICKED_STACK = 8;
        protected static final ResourceLocation BACKGROUND = new ResourceLocation("engineersdecor", "textures/gui/treated_wood_crafting_table.png");
        protected final BTileEntity te;
        protected final EntityPlayer player;
        protected final ArrayList<GuiButton> field_146292_n = new ArrayList();
        protected final boolean[] history_slot_tooltip = new boolean[]{false, false, false, false, false, false, false, false, false, false};

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
            this.player = playerInventory.field_70458_d;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            this.field_146292_n.clear();
            if (with_assist) {
                this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(0, x0 + 158, y0 + 44, 12, 12, 194, 44, 12, BACKGROUND){

                    public void func_194829_a(double mouseX, double mouseY) {
                        this.action_performed((GuiButton)this);
                    }
                }));
                this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(1, x0 + 158, y0 + 30, 12, 12, 180, 30, 12, BACKGROUND){

                    public void func_194829_a(double mouseX, double mouseY) {
                        this.action_performed((GuiButton)this);
                    }
                }));
                this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(2, x0 + 158, y0 + 58, 12, 12, 194, 8, 12, BACKGROUND){

                    public void func_194829_a(double mouseX, double mouseY) {
                        this.action_performed((GuiButton)this);
                    }
                }));
                if (with_assist_quickmove_buttons) {
                    this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(3, x0 + 49, y0 + 34, 9, 17, 219, 34, 17, BACKGROUND){

                        public void func_194829_a(double mouseX, double mouseY) {
                            this.action_performed((GuiButton)this);
                        }
                    }));
                    this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(4, x0 + 49, y0 + 52, 9, 17, 208, 16, 17, BACKGROUND){

                        public void func_194829_a(double mouseX, double mouseY) {
                            this.action_performed((GuiButton)this);
                        }
                    }));
                    this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(5, x0 + 77, y0 + 71, 17, 9, 198, 71, 9, BACKGROUND){

                        public void func_194829_a(double mouseX, double mouseY) {
                            this.action_performed((GuiButton)this);
                        }
                    }));
                    this.field_146292_n.add(this.func_189646_b((GuiButton)new GuiButtonImage(6, x0 + 59, y0 + 71, 17, 9, 180, 71, 9, BACKGROUND){

                        public void func_194829_a(double mouseX, double mouseY) {
                            this.action_performed((GuiButton)this);
                        }
                    }));
                }
            }
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_191948_b(int mouseX, int mouseY) {
            if (!this.player.field_71071_by.func_70445_o().func_190926_b() || this.getSlotUnderMouse() == null) {
                return;
            }
            Slot slot = this.getSlotUnderMouse();
            if (!slot.func_75211_c().func_190926_b()) {
                this.func_146285_a(slot.func_75211_c(), mouseX, mouseY);
                return;
            }
            if (with_assist) {
                int hist_index = -1;
                if (slot instanceof BSlotCrafting) {
                    hist_index = 0;
                } else if (slot.field_75224_c instanceof BInventoryCrafting) {
                    hist_index = slot.getSlotIndex() + 1;
                }
                if (hist_index < 0 || hist_index >= this.history_slot_tooltip.length) {
                    return;
                }
                if (!this.history_slot_tooltip[hist_index]) {
                    return;
                }
                ItemStack hist_stack = this.te.history.current().get(hist_index);
                if (!hist_stack.func_190926_b()) {
                    this.func_146285_a(hist_stack, mouseX, mouseY);
                }
            }
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(x0, y0, 0, 0, this.field_146999_f, this.field_147000_g);
            if (with_assist) {
                for (int i = 0; i < this.history_slot_tooltip.length; ++i) {
                    this.history_slot_tooltip[i] = false;
                }
                List<ItemStack> crafting_template = this.te.history.current();
                if (crafting_template == null || crafting_template.isEmpty()) {
                    return;
                }
                int i = 0;
                for (Tuple e : ((BContainer)this.field_147002_h).CRAFTING_SLOT_POSITIONS) {
                    if (i == 0) continue;
                    if (this.field_147002_h.func_75139_a(i).func_75216_d() && !this.field_147002_h.func_75139_a(i).func_75211_c().func_77969_a(crafting_template.get(i))) {
                        return;
                    }
                    ++i;
                }
                i = 0;
                for (Tuple e : ((BContainer)this.field_147002_h).CRAFTING_SLOT_POSITIONS) {
                    ItemStack stack = crafting_template.get(i);
                    if (!stack.func_190926_b()) {
                        if (!this.field_147002_h.func_75139_a(i).func_75216_d()) {
                            this.history_slot_tooltip[i] = true;
                        }
                        if (i == 0 && this.field_147002_h.func_75139_a(i).func_75211_c().func_77969_a(crafting_template.get(i))) continue;
                        this.draw_template_item_at(stack, x0, y0, (Integer)e.func_76341_a(), (Integer)e.func_76340_b());
                    }
                    ++i;
                }
            }
        }

        protected void draw_template_item_at(ItemStack stack, int x0, int y0, int x, int y) {
            float main_zl = this.field_73735_i;
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            float zl = this.field_146296_j.field_77023_b;
            this.field_146296_j.field_77023_b = -50.0f;
            this.field_146296_j.func_175042_a(stack, x0 + x, y0 + y);
            this.field_146296_j.field_77023_b = zl;
            this.field_73735_i = 100.0f;
            GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)0.7f, (float)0.8f);
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
            this.func_73729_b(x0 + x, y0 + y, x, y, 16, 16);
            RenderHelper.func_74520_c();
            RenderHelper.func_74519_b();
            this.field_73735_i = main_zl;
        }

        protected void action_performed(GuiButton button) {
            switch (button.field_146127_k) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("action", button.field_146127_k);
                    Networking.PacketTileNotifyClientToServer.sendToServer(this.te, nbt);
                    break;
                }
            }
        }

        protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
            if (type == ClickType.PICKUP) {
                boolean place_refab;
                boolean bl = place_refab = slot instanceof BSlotCrafting && !slot.func_75216_d();
                if (place_refab && with_assist_direct_history_refab) {
                    this.on_history_item_placement();
                }
                super.func_184098_a(slot, slotId, mouseButton, type);
                if (place_refab && !with_assist_direct_history_refab) {
                    this.on_history_item_placement();
                }
                return;
            }
            if (type == ClickType.QUICK_MOVE && slotId > 9 && slot.func_75216_d()) {
                boolean palce_in_crafting_grid;
                List<ItemStack> history = this.te.history.current();
                boolean bl = palce_in_crafting_grid = !history.isEmpty();
                if (!palce_in_crafting_grid) {
                    for (int i = 0; i < 9; ++i) {
                        if (this.te.func_70301_a(i).func_190926_b()) continue;
                        palce_in_crafting_grid = true;
                        break;
                    }
                }
                if (palce_in_crafting_grid) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("action", 8);
                    nbt.func_74768_a("containerslot", slotId);
                    Networking.PacketTileNotifyClientToServer.sendToServer(this.te, nbt);
                    return;
                }
            }
            super.func_184098_a(slot, slotId, mouseButton, type);
        }

        private void on_history_item_placement() {
            if (this.te.history.current().isEmpty()) {
                return;
            }
            Slot resultSlot = this.getSlotUnderMouse();
            if (!(resultSlot instanceof BSlotCrafting)) {
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("action", 7);
            Networking.PacketTileNotifyClientToServer.sendToServer(this.te, nbt);
        }
    }

    private static class CraftingHistory {
        public static final int RESULT_STACK_INDEX = 0;
        public static final int INPUT_STACKS_BEGIN = 1;
        public static final List<ItemStack> NOTHING = new ArrayList<ItemStack>();
        private static int max_history_size_ = 5;
        public World world;
        private List<String> history_ = new ArrayList<String>();
        private int current_ = -1;
        private List<ItemStack> current_stacks_ = new ArrayList<ItemStack>();
        private IRecipe current_recipe_ = null;

        public static int max_history_size() {
            return max_history_size_;
        }

        public static int max_history_size(int newsize) {
            max_history_size_ = MathHelper.func_76125_a((int)newsize, (int)0, (int)32);
            return max_history_size_;
        }

        public void read(NBTTagCompound nbt) {
            try {
                this.clear();
                NBTTagCompound subsect = nbt.func_74775_l("history");
                if (subsect.isEmpty()) {
                    return;
                }
                String s = subsect.func_74779_i("elements");
                if (s != null && s.length() > 0) {
                    String[] ls;
                    for (String e : ls = s.split("[|]")) {
                        this.history_.add(e.toLowerCase().trim());
                    }
                }
                this.current_ = !subsect.func_74764_b("current") ? -1 : MathHelper.func_76125_a((int)subsect.func_74762_e("current"), (int)-1, (int)(this.history_.size() - 1));
                this.update_current();
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger().error("Exception reading crafting table history NBT, resetting, exception is:" + ex.getMessage());
                this.clear();
            }
        }

        public void write(NBTTagCompound nbt) {
            NBTTagCompound subsect = new NBTTagCompound();
            subsect.func_74768_a("current", this.current_);
            subsect.func_74778_a("elements", String.join((CharSequence)"|", this.history_));
            nbt.func_74782_a("history", (INBTBase)subsect);
        }

        public void clear() {
            this.reset_current();
            this.history_.clear();
        }

        public void reset_current() {
            this.current_ = -1;
            this.current_stacks_ = NOTHING;
            this.current_recipe_ = null;
        }

        void update_current() {
            if (this.current_ < 0 || this.current_ >= this.history_.size()) {
                this.reset_current();
                return;
            }
            Tuple<IRecipe, List<ItemStack>> data = this.str2stacks(this.history_.get(this.current_));
            if (data == null) {
                this.reset_current();
                return;
            }
            this.current_recipe_ = (IRecipe)data.func_76341_a();
            this.current_stacks_ = (List)data.func_76340_b();
        }

        public void add(List<ItemStack> grid_stacks, IRecipe recipe) {
            if (!with_assist) {
                this.clear();
                return;
            }
            String s = this.stacks2str(grid_stacks, recipe);
            String recipe_filter = recipe.func_199560_c().toString() + ";";
            if (s.isEmpty()) {
                return;
            }
            this.history_.removeIf(e -> e.equals(s));
            this.history_.removeIf(e -> e.startsWith(recipe_filter));
            this.history_.add(s);
            while (this.history_.size() > CraftingHistory.max_history_size()) {
                this.history_.remove(0);
            }
            if (this.current_ >= this.history_.size()) {
                this.reset_current();
            }
        }

        public String stacks2str(List<ItemStack> grid_stacks, IRecipe recipe) {
            if (grid_stacks == null || grid_stacks.size() != 10 || recipe == null) {
                return "";
            }
            if (grid_stacks.get(0).func_190926_b()) {
                return "";
            }
            ArrayList<String> items = new ArrayList<String>();
            items.add(recipe.func_199560_c().toString().trim());
            for (ItemStack st : grid_stacks) {
                items.add(st.func_190926_b() ? "" : st.func_77973_b().getRegistryName().toString().trim());
            }
            return String.join((CharSequence)";", items);
        }

        @Nullable
        public Tuple<IRecipe, List<ItemStack>> str2stacks(String entry) {
            if (this.world == null || entry == null || entry.isEmpty()) {
                return null;
            }
            try {
                ArrayList<String> item_regnames = new ArrayList<String>(Arrays.asList(entry.split("[;]")));
                if (item_regnames == null || item_regnames.size() < 2 || item_regnames.size() > 11) {
                    return null;
                }
                while (item_regnames.size() < 11) {
                    item_regnames.add("");
                }
                String recipe_name = item_regnames.remove(0);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (String regname : item_regnames) {
                    ItemStack stack = ItemStack.field_190927_a;
                    if (!regname.isEmpty()) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(regname));
                        stack = item == null || item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item, 1);
                    }
                    stacks.add(stack);
                }
                if (stacks.size() != 10 || ((ItemStack)stacks.get(0)).func_190926_b()) {
                    return null;
                }
                IRecipe recipe = this.world.func_199532_z().func_199517_a(new ResourceLocation(recipe_name));
                if (recipe == null) {
                    return null;
                }
                return new Tuple((Object)recipe, stacks);
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger().error("History stack building failed: " + ex.getMessage());
                return null;
            }
        }

        public List<ItemStack> current() {
            return this.current_stacks_;
        }

        public IRecipe current_recipe() {
            return this.current_recipe_;
        }

        public void next() {
            this.current_ = this.history_.isEmpty() ? -1 : (++this.current_ >= this.history_.size() ? -1 : this.current_);
            this.update_current();
        }

        public void prev() {
            this.current_ = this.history_.isEmpty() ? -1 : (--this.current_ < -1 ? this.history_.size() - 1 : this.current_);
            this.update_current();
        }

        public void reset_selection() {
            this.current_ = -1;
            this.update_current();
        }

        public String toString() {
            String rec = this.current_recipe_ == null ? "none" : this.current_recipe_.func_199560_c().toString();
            StringBuilder s = new StringBuilder("{ current:" + this.current_ + ", recipe:'" + rec + "', elements:[ ");
            for (int i = 0; i < this.history_.size(); ++i) {
                s.append("{i:").append(i).append(", e:[").append(this.history_.get(i)).append("]} ");
            }
            s.append("]}");
            return s.toString();
        }
    }

    public static class BInteraction
    implements IInteractionObject {
        private final World world;
        private final BlockPos pos;
        private final BTileEntity te;

        public BInteraction(World world, BlockPos pos, BTileEntity te) {
            this.world = world;
            this.pos = pos;
            this.te = te;
        }

        public ITextComponent func_200200_C_() {
            return new TextComponentTranslation(ModBlocks.TREATED_WOOD_CRAFTING_TABLE.func_149739_a(), new Object[0]);
        }

        public boolean func_145818_k_() {
            return false;
        }

        public String func_174875_k() {
            return ModBlocks.TREATED_WOOD_CRAFTING_TABLE.getRegistryName().toString();
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }

        public Container func_174876_a(InventoryPlayer inv, EntityPlayer player) {
            return new BContainer(inv, this.world, this.pos, this.te);
        }
    }
}

