/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.blocks.BlockDecorFurnace;
import wile.engineersdecor.blocks.ModBlocks;

public class BlockDecorFurnaceElectrical
extends BlockDecorFurnace {
    public BlockDecorFurnaceElectrical(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config, builder, unrotatedAABB);
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new BTileEntity();
    }

    @Override
    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        if (!(player instanceof EntityPlayerMP) && !(player instanceof FakePlayer)) {
            return true;
        }
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BInteraction(world, pos, (BTileEntity)te), buf -> buf.func_179255_a(pos));
        player.func_195066_a(StatList.field_188061_aa);
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
            return;
        }
        NBTTagCompound inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
        if (inventory_nbt.isEmpty()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        BTileEntity bte = (BTileEntity)te;
        bte.readnbt(inventory_nbt);
        bte.func_70296_d();
        world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(bte.isBurning())));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
    }

    public static class BTileEntity
    extends BlockDecorFurnace.BTileEntity
    implements ITickable,
    ISidedInventory,
    IEnergyStorage {
        public static final int TICK_INTERVAL = 4;
        public static final int FIFO_INTERVAL = 20;
        public static final int HEAT_CAPACITY = 200;
        public static final int HEAT_INCREMENT = 20;
        public static final int MAX_ENERGY_TRANSFER = 256;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_SPEED_SETTING = 2;
        public static final int NUM_OF_SLOTS = 7;
        public static final int SMELTING_INPUT_SLOT_NO = 0;
        public static final int SMELTING_AUX_SLOT_NO = 1;
        public static final int SMELTING_OUTPUT_SLOT_NO = 2;
        public static final int FIFO_INPUT_0_SLOT_NO = 3;
        public static final int FIFO_INPUT_1_SLOT_NO = 4;
        public static final int FIFO_OUTPUT_0_SLOT_NO = 5;
        public static final int FIFO_OUTPUT_1_SLOT_NO = 6;
        public static final int DEFAULT_SPEED_PERCENT = 200;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
        public static final int DEFAULT_SCALED_ENERGY_CONSUMPTION = 640;
        private static boolean with_automatic_inventory_pulling_ = false;
        private static int energy_consumption_ = 640;
        private static int transfer_energy_consumption_ = 80;
        private static int proc_speed_percent_ = 200;
        private int burntime_left_;
        private int proc_time_elapsed_;
        private int proc_time_needed_;
        private int energy_stored_;
        private int speed_;
        private int tick_timer_;
        private int fifo_timer_;
        private static final int[] SIDED_INV_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6};
        protected LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new BItemHandler(this));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int speed_percent, int standard_energy_per_tick, boolean with_automatic_inventory_pulling) {
            proc_speed_percent_ = MathHelper.func_76125_a((int)speed_percent, (int)10, (int)500);
            energy_consumption_ = MathHelper.func_76125_a((int)standard_energy_per_tick, (int)10, (int)256) * 20 * proc_speed_percent_ / 100;
            transfer_energy_consumption_ = MathHelper.func_76125_a((int)(energy_consumption_ / 8), (int)8, (int)20);
            with_automatic_inventory_pulling_ = with_automatic_inventory_pulling;
            ModEngineersDecor.logger().info("Config electrical furnace speed:" + proc_speed_percent_ + ", power consumption:" + energy_consumption_);
        }

        public BTileEntity() {
            this(ModBlocks.TET_SMALL_ELECTRICAL_FURNACE);
        }

        public BTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        @Override
        public void reset() {
            super.reset();
            this.stacks_ = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
            this.burntime_left_ = 0;
            this.proc_time_elapsed_ = 0;
            this.proc_time_needed_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.energy_stored_ = 0;
            this.speed_ = 0;
        }

        @Override
        public void readnbt(NBTTagCompound nbt) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.stacks_);
            while (this.stacks_.size() < 7) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.burntime_left_ = nbt.func_74762_e("BurnTime");
            this.proc_time_elapsed_ = nbt.func_74762_e("CookTime");
            this.proc_time_needed_ = nbt.func_74762_e("CookTimeTotal");
            this.energy_stored_ = nbt.func_74762_e("Energy");
            this.speed_ = nbt.func_74762_e("SpeedSetting");
        }

        protected void writenbt(NBTTagCompound nbt) {
            nbt.func_74768_a("BurnTime", MathHelper.func_76125_a((int)this.burntime_left_, (int)0, (int)200));
            nbt.func_74768_a("CookTime", MathHelper.func_76125_a((int)this.proc_time_elapsed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTimeTotal", MathHelper.func_76125_a((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("Energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)32000));
            nbt.func_74768_a("SpeedSetting", MathHelper.func_76125_a((int)this.speed_, (int)-1, (int)2));
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.stacks_);
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        @Override
        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return block != null ? block.func_200291_n() : new TextComponentString("Small electrical furnace");
        }

        @Override
        public boolean func_94041_b(int index, ItemStack stack) {
            switch (index) {
                case 0: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int func_174887_a_(int id) {
            switch (id) {
                case 0: {
                    return this.burntime_left_;
                }
                case 1: {
                    return this.energy_stored_;
                }
                case 2: {
                    return this.proc_time_elapsed_;
                }
                case 3: {
                    return this.proc_time_needed_;
                }
                case 4: {
                    return this.speed_;
                }
            }
            return 0;
        }

        @Override
        public void func_174885_b(int id, int value) {
            switch (id) {
                case 0: {
                    this.burntime_left_ = value;
                    break;
                }
                case 1: {
                    this.energy_stored_ = value;
                    break;
                }
                case 2: {
                    this.proc_time_elapsed_ = value;
                    break;
                }
                case 3: {
                    this.proc_time_needed_ = value;
                    break;
                }
                case 4: {
                    this.speed_ = value;
                }
            }
        }

        @Override
        public int func_174890_g() {
            return 7;
        }

        @Override
        public boolean isBurning() {
            return this.burntime_left_ > 0;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = (ItemStack)this.stacks_.get(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = (ItemStack)this.stacks_.get(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.stacks_.set(index_to, (Object)from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (!from.func_77969_a(to) || !ItemStack.func_77970_a((ItemStack)from, (ItemStack)to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        @Override
        public ItemStack func_70301_a(int index) {
            return index < 0 || index >= SIDED_INV_SLOTS.length ? ItemStack.field_190927_a : (ItemStack)this.stacks_.get(SIDED_INV_SLOTS[index]);
        }

        @Override
        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        @Override
        public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
            return this.func_94041_b(index, itemStackIn);
        }

        @Override
        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return index != 0 && index != 3 && index != 4 || stack.func_77973_b() == Items.field_151133_ar;
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return true;
        }

        @Override
        public int getMaxEnergyStored() {
            return 32000;
        }

        @Override
        public int getEnergyStored() {
            return this.energy_stored_;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 32000) {
                return 0;
            }
            int n = Math.min(maxReceive, 32000 - this.energy_stored_);
            if (n > 256) {
                n = 256;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        @Override
        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (!this.field_145846_f && facing != null) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.item_handler_.cast();
                }
                if (capability == CapabilityEnergy.ENERGY) {
                    return this.energy_handler_.cast();
                }
            }
            return super.getCapability(capability, facing);
        }

        private boolean adjacent_inventory_shift(boolean inp, boolean out) {
            IItemHandler hnd;
            TileEntity te;
            boolean dirty = false;
            if (this.energy_stored_ < transfer_energy_consumption_) {
                return false;
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorFurnaceElectrical)) {
                return false;
            }
            EnumFacing out_facing = (EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING);
            if (out && !((ItemStack)this.stacks_.get(6)).func_190926_b() && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(out_facing))) != null && (hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, out_facing).orElse(null)) != null) {
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)hnd, (ItemStack)((ItemStack)this.stacks_.get(6)).func_77946_l(), (boolean)false);
                this.stacks_.set(6, (Object)remaining);
                this.energy_stored_ -= transfer_energy_consumption_;
                dirty = true;
            }
            if (with_automatic_inventory_pulling_) {
                IItemHandler hnd2;
                TileEntity te2;
                EnumFacing inp_facing = ((EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING)).func_176734_d();
                if (inp && ((ItemStack)this.stacks_.get(4)).func_190926_b() && (te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(inp_facing))) != null && (hnd2 = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inp_facing).orElse(null)) != null) {
                    for (int i = 0; i < hnd2.getSlots(); ++i) {
                        ItemStack adj_stack = hnd2.getStackInSlot(i);
                        if (adj_stack.func_190926_b()) continue;
                        ItemStack my_stack = adj_stack.func_77946_l();
                        if (my_stack.func_190916_E() > this.func_70297_j_()) {
                            my_stack.func_190920_e(this.func_70297_j_());
                        }
                        adj_stack.func_190918_g(my_stack.func_190916_E());
                        this.stacks_.set(4, (Object)my_stack);
                        this.energy_stored_ -= transfer_energy_consumption_;
                        dirty = true;
                        break;
                    }
                }
            }
            return dirty;
        }

        private boolean heat_up() {
            if (this.energy_stored_ < energy_consumption_) {
                return false;
            }
            if (this.burntime_left_ >= 180) {
                return false;
            }
            this.energy_stored_ -= energy_consumption_;
            this.burntime_left_ += 20;
            this.func_70296_d();
            return true;
        }

        private void sync_blockstate() {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof BlockDecorFurnaceElectrical && ((Boolean)state.func_177229_b((IProperty)BlockDecorFurnace.LIT)).booleanValue() != this.isBurning()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (IBlockState)state.func_206870_a((IProperty)BlockDecorFurnace.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 2);
            }
        }

        @Override
        public void func_73660_a() {
            boolean update_blockstate;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            boolean was_burning = this.isBurning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = update_blockstate = was_burning != this.isBurning();
            boolean shift_in = false;
            boolean shift_out = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(5, 6, 64)) {
                    dirty = true;
                } else {
                    shift_out = true;
                }
                if (this.transferItems(2, 5, 64)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 64)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 64)) {
                    dirty = true;
                } else {
                    shift_in = true;
                }
            }
            if (!((ItemStack)this.stacks_.get(0)).func_190926_b() && this.energy_stored_ >= energy_consumption_) {
                this.update_current_recipe();
                boolean can_smelt = this.canSmelt();
                if (!can_smelt && this.getSmeltingResult((ItemStack)this.stacks_.get(0)).func_190926_b()) {
                    if (this.transferItems(0, 2, 1)) {
                        dirty = true;
                    }
                } else {
                    if (!this.isBurning() && can_smelt && this.heat_up()) {
                        dirty = true;
                        update_blockstate = true;
                    }
                    if (this.isBurning() && can_smelt) {
                        if (this.heat_up()) {
                            dirty = true;
                        }
                        this.proc_time_elapsed_ += 4 * proc_speed_percent_ / 100;
                        if (this.proc_time_elapsed_ >= this.proc_time_needed_) {
                            this.proc_time_elapsed_ = 0;
                            this.proc_time_needed_ = this.getCookTime((ItemStack)this.stacks_.get(0));
                            this.smeltItem();
                            dirty = true;
                            shift_out = true;
                        }
                    } else {
                        this.proc_time_elapsed_ = 0;
                    }
                }
            } else if (this.proc_time_elapsed_ > 0) {
                this.proc_time_elapsed_ -= ((ItemStack)this.stacks_.get(0)).func_190926_b() ? 20 : 1;
                if (this.proc_time_elapsed_ < 0) {
                    this.proc_time_elapsed_ = 0;
                    shift_out = true;
                    update_blockstate = true;
                }
            }
            if (update_blockstate) {
                dirty = true;
                this.sync_blockstate();
            }
            if (this.adjacent_inventory_shift(shift_in, shift_out)) {
                dirty = true;
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        protected static class BItemHandler
        implements IItemHandler {
            private BTileEntity te;

            BItemHandler(BTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return SIDED_INV_SLOTS.length;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (index < 0 || index >= SIDED_INV_SLOTS.length) {
                    return ItemStack.field_190927_a;
                }
                int slotno = SIDED_INV_SLOTS[index];
                ItemStack slotstack = this.getStackInSlot(slotno);
                if (!slotstack.func_190926_b()) {
                    if (slotstack.func_190916_E() >= Math.min(slotstack.func_77976_d(), this.getSlotLimit(index))) {
                        return stack;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotstack)) {
                        return stack;
                    }
                    if (!this.te.func_180462_a(slotno, stack, EnumFacing.UP) || !this.te.func_94041_b(slotno, stack)) {
                        return stack;
                    }
                    int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index)) - slotstack.func_190916_E();
                    if (stack.func_190916_E() <= n) {
                        if (!simulate) {
                            ItemStack copy = stack.func_77946_l();
                            copy.func_190917_f(slotstack.func_190916_E());
                            this.te.func_70299_a(slotno, copy);
                        }
                        return ItemStack.field_190927_a;
                    }
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        ItemStack copy = stack.func_77979_a(n);
                        copy.func_190917_f(slotstack.func_190916_E());
                        this.te.func_70299_a(slotno, copy);
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!this.te.func_180462_a(slotno, stack, EnumFacing.UP) || !this.te.func_94041_b(slotno, stack)) {
                    return stack;
                }
                int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index));
                if (n < stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        this.te.func_70299_a(slotno, stack.func_77979_a(n));
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!simulate) {
                    this.te.func_70299_a(slotno, stack);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                if (amount == 0) {
                    return ItemStack.field_190927_a;
                }
                if (index < 0 || index >= SIDED_INV_SLOTS.length) {
                    return ItemStack.field_190927_a;
                }
                int slotno = SIDED_INV_SLOTS[index];
                ItemStack stackInSlot = this.getStackInSlot(slotno);
                if (stackInSlot.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.te.func_180461_b(slotno, stackInSlot, EnumFacing.DOWN)) {
                    return ItemStack.field_190927_a;
                }
                if (simulate) {
                    if (stackInSlot.func_190916_E() < amount) {
                        return stackInSlot.func_77946_l();
                    }
                    ItemStack ostack = stackInSlot.func_77946_l();
                    ostack.func_190920_e(amount);
                    return ostack;
                }
                ItemStack ostack = this.te.func_70298_a(slotno, Math.min(stackInSlot.func_190916_E(), amount));
                this.te.func_70296_d();
                return ostack;
            }
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 7;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int burntime_left_;
        private int energy_stored_;
        private int proc_time_elapsed_;
        private int proc_time_needed_;
        private int speed_;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            this.func_75146_a(new Slot((IInventory)te, 0, 59, 28));
            this.func_75146_a(new Slot((IInventory)te, 1, 16, 52));
            this.func_75146_a(new BlockDecorFurnace.BSlotResult(playerInventory.field_70458_d, te, 2, 101, 28));
            this.func_75146_a(new BlockDecorFurnace.BSlotInpFifo((IInventory)te, 3, 34, 28));
            this.func_75146_a(new BlockDecorFurnace.BSlotInpFifo((IInventory)te, 4, 16, 28));
            this.func_75146_a(new BlockDecorFurnace.BSlotOutFifo(playerInventory.field_70458_d, te, 5, 126, 28));
            this.func_75146_a(new BlockDecorFurnace.BSlotOutFifo(playerInventory.field_70458_d, te, 6, 144, 28));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(i);
                if (this.burntime_left_ != this.te.func_174887_a_(0)) {
                    lis.func_71112_a((Container)this, 0, this.te.func_174887_a_(0));
                }
                if (this.energy_stored_ != this.te.func_174887_a_(1)) {
                    lis.func_71112_a((Container)this, 1, this.te.func_174887_a_(1));
                }
                if (this.proc_time_elapsed_ != this.te.func_174887_a_(2)) {
                    lis.func_71112_a((Container)this, 2, this.te.func_174887_a_(2));
                }
                if (this.proc_time_needed_ != this.te.func_174887_a_(3)) {
                    lis.func_71112_a((Container)this, 3, this.te.func_174887_a_(3));
                }
                if (this.speed_ == this.te.func_174887_a_(4)) continue;
                lis.func_71112_a((Container)this, 4, this.te.func_174887_a_(4));
            }
            this.burntime_left_ = this.te.func_174887_a_(0);
            this.energy_stored_ = this.te.func_174887_a_(1);
            this.proc_time_elapsed_ = this.te.func_174887_a_(2);
            this.proc_time_needed_ = this.te.func_174887_a_(3);
            this.speed_ = this.te.func_174887_a_(4);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_75137_b(int id, int data) {
            this.te.func_174885_b(id, data);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorFurnaceElectrical && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 2 || index == 5 || index == 6) {
                if (!this.func_75135_a(slot_stack, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.func_75135_a(slot_stack, 7, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(slot_stack, 7, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 7 && index <= 43) {
                if (this.te.canBeSmelted(slot_stack) ? !this.func_75135_a(slot_stack, 0, 1, false) && !this.func_75135_a(slot_stack, 3, 4, false) && !this.func_75135_a(slot_stack, 4, 5, false) : (index >= 7 && index < 34 ? !this.func_75135_a(slot_stack, 34, 43, false) : index >= 34 && index < 43 && !this.func_75135_a(slot_stack, 7, 34, false))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_electrical_furnace_gui.png"));
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_73729_b(x0, y0, 0, 0, w, h);
            if (BTileEntity.isBurning((IInventory)this.te)) {
                int hi = 13;
                int k = this.heat_px(13);
                this.func_73729_b(x0 + 61, y0 + 53 + 13 - k, 177, 13 - k, 13, k);
            }
            this.func_73729_b(x0 + 79, y0 + 30, 176, 15, 1 + this.progress_px(17), 15);
            int we = this.energy_px(32, 8);
            if (we > 0) {
                this.func_73729_b(x0 + 88, y0 + 53, 185, 30, we, 13);
            }
        }

        private int progress_px(int pixels) {
            int tc = this.te.func_174887_a_(2);
            int T = this.te.func_174887_a_(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int heat_px(int pixels) {
            int k = this.te.func_174887_a_(0) * (pixels + 1) / 200;
            return k < pixels ? k : pixels;
        }

        private int energy_px(int maxwidth, int quantization) {
            int k = maxwidth * this.te.func_174887_a_(1) * 9 / 8 / (this.te.getMaxEnergyStored() + 1);
            int n = k = k >= maxwidth - 2 ? maxwidth : k;
            if (quantization > 0) {
                k = (k + quantization / 2) / quantization * quantization;
            }
            return k;
        }
    }

    public static class BInteraction
    implements IInteractionObject {
        private final World world;
        private final BlockPos pos;
        private final BTileEntity te;

        public BInteraction(World world, BlockPos pos, BTileEntity te) {
            this.world = world;
            this.pos = pos;
            this.te = te;
        }

        public ITextComponent func_200200_C_() {
            return new TextComponentTranslation(ModBlocks.SMALL_ELECTRICAL_FURNACE.func_149739_a(), new Object[0]);
        }

        public boolean func_145818_k_() {
            return false;
        }

        public String func_174875_k() {
            return ModBlocks.SMALL_ELECTRICAL_FURNACE.getRegistryName().toString();
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }

        public Container func_174876_a(InventoryPlayer inv, EntityPlayer player) {
            return new BContainer(inv, this.world, this.pos, this.te);
        }
    }
}

