/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.blocks.ModBlocks;

public class BlockDecorPipeValve
extends BlockDecorDirected {
    public static final BooleanProperty RS_CN_N = BooleanProperty.func_177716_a((String)"rs_n");
    public static final BooleanProperty RS_CN_S = BooleanProperty.func_177716_a((String)"rs_s");
    public static final BooleanProperty RS_CN_E = BooleanProperty.func_177716_a((String)"rs_e");
    public static final BooleanProperty RS_CN_W = BooleanProperty.func_177716_a((String)"rs_w");
    public static final BooleanProperty RS_CN_U = BooleanProperty.func_177716_a((String)"rs_u");
    public static final BooleanProperty RS_CN_D = BooleanProperty.func_177716_a((String)"rs_d");

    public static void on_config(int container_size_decl, int redstone_slope) {
        BTileEntity.fluid_maxflow_mb = MathHelper.func_76125_a((int)container_size_decl, (int)1, (int)10000);
        BTileEntity.redstone_flow_slope_mb = MathHelper.func_76125_a((int)redstone_slope, (int)1, (int)10000);
        ModEngineersDecor.logger().info("Config pipe valve: maxflow:" + BTileEntity.fluid_maxflow_mb + "mb, redstone amp:" + BTileEntity.redstone_flow_slope_mb + "mb/sig");
    }

    public BlockDecorPipeValve(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config, builder, unrotatedAABB);
    }

    private IBlockState get_rsconnector_state(IBlockState state, IWorld world, BlockPos pos, @Nullable BlockPos fromPos) {
        if ((this.config & 0x20000L) == 0L) {
            return state;
        }
        EnumFacing.Axis bfa = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k();
        int bfi = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        block8: for (EnumFacing f : EnumFacing.values()) {
            boolean cn;
            boolean bl = cn = f.func_176740_k() != bfa;
            if (cn) {
                BlockPos nbp = pos.func_177972_a(f);
                if (fromPos != null && !nbp.equals((Object)fromPos)) continue;
                IBlockState nbs = world.func_180495_p(nbp);
                if (!nbs.func_185897_m()) {
                    cn = false;
                }
            }
            switch (f) {
                case NORTH: {
                    state = (IBlockState)state.func_206870_a((IProperty)RS_CN_N, (Comparable)Boolean.valueOf(cn));
                    continue block8;
                }
                case SOUTH: {
                    state = (IBlockState)state.func_206870_a((IProperty)RS_CN_S, (Comparable)Boolean.valueOf(cn));
                    continue block8;
                }
                case EAST: {
                    state = (IBlockState)state.func_206870_a((IProperty)RS_CN_E, (Comparable)Boolean.valueOf(cn));
                    continue block8;
                }
                case WEST: {
                    state = (IBlockState)state.func_206870_a((IProperty)RS_CN_W, (Comparable)Boolean.valueOf(cn));
                    continue block8;
                }
                case UP: {
                    state = (IBlockState)state.func_206870_a((IProperty)RS_CN_U, (Comparable)Boolean.valueOf(cn));
                    continue block8;
                }
                case DOWN: {
                    state = (IBlockState)state.func_206870_a((IProperty)RS_CN_D, (Comparable)Boolean.valueOf(cn));
                }
            }
        }
        return state;
    }

    private void update_te(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BTileEntity) {
            ((BTileEntity)te).block_reconfigure((EnumFacing)state.func_177229_b((IProperty)FACING), this.config);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, RS_CN_N, RS_CN_S, RS_CN_E, RS_CN_W, RS_CN_U, RS_CN_D});
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)super.func_196258_a(context).func_206870_a((IProperty)RS_CN_N, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)RS_CN_S, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)RS_CN_E, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)RS_CN_W, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)RS_CN_U, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)RS_CN_D, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.get_rsconnector_state(state, world, pos, null);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.update_te(world, state, pos);
        world.func_195593_d(pos, (Block)this);
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing fc = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (fromPos.equals((Object)pos.func_177972_a(fc)) || fromPos.equals((Object)pos.func_177972_a(fc.func_176734_d()))) {
            this.update_te(world, state, pos);
        } else {
            IBlockState connector_state = this.get_rsconnector_state(state, (IWorld)world, pos, fromPos);
            if (!state.equals(connector_state)) {
                world.func_175656_a(pos, connector_state);
            }
        }
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new BTileEntity();
    }

    public boolean canConnectRedstone(IBlockState state, IBlockReader world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null && side != state.func_177229_b((IProperty)FACING) && side != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
    }

    public static class BTileEntity
    extends TileEntity
    implements IFluidHandler,
    IFluidTankProperties,
    ICapabilityProvider,
    IFluidPipe {
        protected static int fluid_maxflow_mb = 1000;
        protected static int redstone_flow_slope_mb = 66;
        private final IFluidTankProperties[] fluid_props_ = new IFluidTankProperties[]{this};
        private EnumFacing block_facing_ = EnumFacing.NORTH;
        private boolean filling_ = false;
        private boolean getlocked_ = false;
        private boolean filling_enabled_ = true;
        private long block_config_ = 0L;
        private static final BackFlowHandler back_flow_handler_singleton_ = new BackFlowHandler();
        private LazyOptional<IFluidHandler> back_flow_handler_ = LazyOptional.of(() -> back_flow_handler_singleton_);
        private LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> this);

        public BTileEntity() {
            this(ModBlocks.TET_STRAIGHT_PIPE_VALVE);
        }

        public BTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void block_reconfigure(EnumFacing facing, long block_config) {
            this.block_facing_ = facing;
            this.block_config_ = block_config;
            this.filling_enabled_ = false;
            IFluidHandler fh = this.forward_fluid_handler();
            if (fh != null) {
                if (fh.getTankProperties().length == 0) {
                    this.filling_enabled_ = true;
                } else {
                    for (IFluidTankProperties fp : fh.getTankProperties()) {
                        if (fp == null || !fp.canFill()) continue;
                        this.filling_enabled_ = true;
                        break;
                    }
                }
            }
        }

        public void onLoad() {
            if (!this.func_145830_o()) {
                return;
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorPipeValve)) {
                return;
            }
            this.block_reconfigure((EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING), this.block_config_);
            this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            int i = nbt.func_74762_e("facing");
            if (i >= 0 || i < 6) {
                this.block_facing_ = EnumFacing.func_82600_a((int)i);
            }
            this.block_config_ = nbt.func_74763_f("conf");
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            nbt.func_74768_a("facing", this.block_facing_.func_176745_a());
            nbt.func_74772_a("conf", this.block_config_);
            return nbt;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (!this.field_145846_f && facing != null && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                if (facing == this.block_facing_) {
                    return this.fluid_handler_.cast();
                }
                if (facing == this.block_facing_.func_176734_d()) {
                    return this.back_flow_handler_.cast();
                }
            }
            return super.getCapability(capability, facing);
        }

        @Nullable
        private IFluidHandler forward_fluid_handler() {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing_));
            if (te == null) {
                return null;
            }
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.block_facing_.func_176734_d()).orElse(null);
        }

        public int fill(FluidStack resource, boolean doFill) {
            TileEntity te;
            IFluidHandler fh;
            if (this.filling_ || !this.filling_enabled_) {
                return 0;
            }
            if ((this.block_config_ & 0x20000L) != 0L) {
                int rs = this.field_145850_b.func_175687_A(this.field_174879_c);
                if (rs <= 0) {
                    return 0;
                }
                if ((this.block_config_ & 0x40000L) != 0L && rs < 15) {
                    resource.amount = MathHelper.func_76125_a((int)(rs * redstone_flow_slope_mb), (int)1, (int)resource.amount);
                }
            }
            FluidStack res = resource.copy();
            if (res.amount > fluid_maxflow_mb) {
                res.amount = fluid_maxflow_mb;
            }
            if ((fh = this.forward_fluid_handler()) == null) {
                return 0;
            }
            this.filling_ = true;
            if (res.amount > 50 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing_))) instanceof IFluidPipe) {
                if (res.tag == null) {
                    res.tag = new NBTTagCompound();
                }
                res.tag.func_74757_a("pressurized", true);
            }
            int n_filled = this.forward_fluid_handler().fill(res, doFill);
            this.filling_ = false;
            return n_filled;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.fluid_props_;
        }

        @Nullable
        public FluidStack getContents() {
            return null;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return false;
        }

        @Override
        public boolean hasOutputConnection(EnumFacing side) {
            return side == this.block_facing_;
        }

        @Override
        public boolean canOutputPressurized(boolean consumePower) {
            if (this.getlocked_ || !this.filling_enabled_) {
                return false;
            }
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing_));
            if (!(te instanceof IFluidPipe)) {
                return false;
            }
            this.getlocked_ = true;
            boolean r = ((IFluidPipe)te).canOutputPressurized(consumePower);
            this.getlocked_ = false;
            return r;
        }

        private static class BackFlowHandler
        implements IFluidHandler,
        IFluidTankProperties {
            private final IFluidTankProperties[] props_ = new IFluidTankProperties[]{this};

            private BackFlowHandler() {
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.props_;
            }

            public int fill(FluidStack resource, boolean doFill) {
                return 0;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack getContents() {
                return null;
            }

            public int getCapacity() {
                return 0;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }
        }
    }
}

