/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.init.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorWall
extends BlockWall {
    private final VoxelShape[] shape_voxels = this.buildWallShapes(4.0f, 4.0f, 16.0f, 0.0f, 16.0f);
    private final VoxelShape[] collision_shape_voxels = this.buildWallShapes(4.0f, 4.0f, 24.0f, 0.0f, 24.0f);
    public static final IntegerProperty TEXTURE_VARIANT = IntegerProperty.func_177719_a((String)"tvariant", (int)0, (int)7);

    public BlockDecorWall(long config, Block.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    protected VoxelShape[] buildWallShapes(float pole_width_x, float pole_width_z, float pole_height, float side_min_y, float side_max_y) {
        return super.func_196408_a(pole_width_x, pole_width_z, pole_height, side_min_y, side_max_y);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.shape_voxels[this.func_196406_i(state)];
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.collision_shape_voxels[this.func_196406_i(state)];
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{TEXTURE_VARIANT});
    }

    private boolean attachesTo(IBlockState state, BlockFaceShape shape) {
        Block block = state.func_177230_c();
        return shape == BlockFaceShape.SOLID && !BlockDecorWall.func_194143_e((Block)block) || shape == BlockFaceShape.MIDDLE_POLE_THICK || shape == BlockFaceShape.MIDDLE_POLE && block instanceof BlockFenceGate;
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)field_204514_u)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)world));
        }
        if (facing == EnumFacing.DOWN) {
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        boolean n = facing == EnumFacing.NORTH ? this.attachesTo(facingState, facingState.func_193401_d((IBlockReader)world, facingPos, facing.func_176734_d())) : ((Boolean)state.func_177229_b((IProperty)field_196409_a)).booleanValue();
        boolean e = facing == EnumFacing.EAST ? this.attachesTo(facingState, facingState.func_193401_d((IBlockReader)world, facingPos, facing.func_176734_d())) : ((Boolean)state.func_177229_b((IProperty)field_196411_b)).booleanValue();
        boolean s = facing == EnumFacing.SOUTH ? this.attachesTo(facingState, facingState.func_193401_d((IBlockReader)world, facingPos, facing.func_176734_d())) : ((Boolean)state.func_177229_b((IProperty)field_196413_c)).booleanValue();
        boolean w = facing == EnumFacing.WEST ? this.attachesTo(facingState, facingState.func_193401_d((IBlockReader)world, facingPos, facing.func_176734_d())) : ((Boolean)state.func_177229_b((IProperty)field_196414_y)).booleanValue();
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176256_a, (Comparable)Boolean.valueOf(not_straight))).func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(n))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(e))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(s))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(w))).func_206870_a((IProperty)TEXTURE_VARIANT, (Comparable)Integer.valueOf((int)MathHelper.func_180186_a((Vec3i)currentPos) & 7));
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }
}

