/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import wile.engineersdecor.ModEngineersDecor;

public class ModAuxiliaries {
    public static TextComponentTranslation localizable(String modtrkey, @Nullable TextFormatting color, Object ... args) {
        TextComponentTranslation tr = new TextComponentTranslation("engineersdecor." + modtrkey, args);
        if (color != null) {
            tr.func_150256_b().func_150238_a(color);
        }
        return tr;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        TextComponentTranslation tr = new TextComponentTranslation(translationKey, args);
        tr.func_150256_b().func_150238_a(TextFormatting.RESET);
        String ft = tr.func_150254_d();
        if (ft.contains("${")) {
            Pattern pt = Pattern.compile("\\$\\{([\\w\\.]+)\\}");
            Matcher mt = pt.matcher(ft);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                mt.appendReplacement(sb, new TextComponentTranslation(mt.group(1), new Object[0]).func_150254_d().trim());
            }
            mt.appendTail(sb);
            return sb.toString();
        }
        return ft;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static final AxisAlignedBB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static final AxisAlignedBB getRotatedAABB(AxisAlignedBB bb, EnumFacing new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, 1.0 - bb.field_72337_e, 1.0 - bb.field_72340_a, 1.0 - bb.field_72339_c, 1.0 - bb.field_72338_b);
                }
                case 1: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72340_a, bb.field_72334_f, bb.field_72337_e);
                }
                case 2: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 3: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 4: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
                case 5: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
            }
        } else {
            switch (new_facing.func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 1: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 2: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 3: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 4: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
                case 5: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
            }
        }
        return bb;
    }

    public static final boolean isModLoaded(String registry_name) {
        return ModList.get().isLoaded(registry_name);
    }

    public static final void logInfo(String msg) {
        ModEngineersDecor.logger().info(msg);
    }

    public static final void logWarn(String msg) {
        ModEngineersDecor.logger().warn(msg);
    }

    public static final void logError(String msg) {
        ModEngineersDecor.logger().error(msg);
    }

    public static void playerChatMessage(EntityPlayer player, String message) {
        String s = message.trim();
        if (!s.isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(s, new Object[0]));
        }
    }

    public static <T extends Entity> EntityType<T> mkEntityType(Class<? extends T> clazz, Function<? super World, ? extends T> factory, String name, boolean tracker_vupdate) {
        return ModAuxiliaries.mkEntityType(clazz, factory, name, tracker_vupdate, 64, 1);
    }

    public static <T extends Entity> EntityType<T> mkEntityType(Class<? extends T> clazz, Function<? super World, ? extends T> factory, String name, boolean tracker_vupdate, int tracker_range, int tracker_freq) {
        ResourceLocation regname = new ResourceLocation("engineersdecor", name);
        EntityType et = EntityType.Builder.func_201757_a(clazz, factory).tracker(tracker_range, tracker_freq, tracker_vupdate).func_206830_a(regname.toString());
        et.setRegistryName(regname);
        return et;
    }

    public static final class Tooltip {
        @OnlyIn(value=Dist.CLIENT)
        public static boolean extendedTipCondition() {
            return InputMappings.func_197956_a((int)340) || InputMappings.func_197956_a((int)344);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean helpCondition() {
            return Tooltip.extendedTipCondition() && (InputMappings.func_197956_a((int)341) || InputMappings.func_197956_a((int)345));
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<ITextComponent> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            if (Tooltip.helpCondition()) {
                if (!help_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add((ITextComponent)new TextComponentString(s));
                return true;
            }
            if (Tooltip.extendedTipCondition()) {
                if (!tip_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add((ITextComponent)new TextComponentString(s));
                return true;
            }
            if (addAdvancedTooltipHints) {
                String s = "";
                if (tip_available) {
                    s = s + ModAuxiliaries.localize("engineersdecor.tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    s = s + ModAuxiliaries.localize("engineersdecor.tooltip.hint.help", new Object[0]);
                }
                tooltip.add((ITextComponent)new TextComponentString(s));
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.func_77977_a(), stack.func_77977_a(), tooltip, flag, addAdvancedTooltipHints);
        }
    }
}

