/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.block;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.player.PlayerData;
import com.pau101.fairylights.tileentity.TileEntityFairyLightsFastener;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Point3i;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockFairyLightsFastener
extends BlockContainer {
    public static final int[] SIDE_TO_DATA = new int[]{2, 0, 12, 4, 1, 3};
    private static final ForgeDirection[] DATA_TO_DIRECTION = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.NORTH, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN};

    public BlockFairyLightsFastener(int id) {
        super(id, Material.field_76265_p);
        this.func_71905_a(0.375f, 0.0f, 0.375f, 0.625f, 0.25f, 0.625f);
    }

    public BlockFairyLightsFastener(int id, Material material) {
        super(id, material);
    }

    public void func_71852_a(World world, int x, int y, int z, int block, int meta) {
        TileEntityFairyLightsFastener fastener = (TileEntityFairyLightsFastener)world.func_72796_p(x, y, z);
        if (fastener == null) {
            return;
        }
        List<TileEntityFairyLightsFastener.Connection> connections = fastener.getConnections();
        float offsetX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        for (TileEntityFairyLightsFastener.Connection connection : connections) {
            if (connection instanceof TileEntityFairyLightsFastener.PlayerConnection) continue;
            ItemStack itemStack = new ItemStack(FairyLights.fairyLights, 1);
            NBTTagCompound tagCompound = new NBTTagCompound("tag");
            connection.writeDetailsToNBT(tagCompound);
            itemStack.func_77982_d(tagCompound);
            EntityItem entityItem = new EntityItem(world, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), itemStack);
            float v = 0.05f;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)v;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)v + (double)0.2f;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)v;
            world.func_72838_d((Entity)entityItem);
        }
        super.func_71852_a(world, x, y, z, block, meta);
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityFairyLightsFastener();
    }

    public boolean func_71918_c(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return Block.field_72079_ak.func_71858_a(0, 0);
    }

    public int func_71922_a(World world, int x, int y, int z) {
        return FairyLights.fairyLights.field_77779_bT;
    }

    public int func_71885_a(int data, Random random, int fortune) {
        return 0;
    }

    public Point3f getOffsetForData(int data, float offset) {
        Point3f offsetPoint = new Point3f(offset, offset, offset);
        switch (data) {
            case 2: {
                offsetPoint.y += 0.75f;
            }
            case 0: {
                offsetPoint.x += 0.375f;
                offsetPoint.z += 0.375f;
                break;
            }
            case 1: {
                offsetPoint.x += 0.75f;
            }
            case 3: {
                offsetPoint.z += 0.375f;
                offsetPoint.y += 0.375f;
                break;
            }
            case 12: {
                offsetPoint.z += 0.75f;
            }
            case 4: {
                offsetPoint.x += 0.375f;
                offsetPoint.y += 0.375f;
            }
        }
        return offsetPoint;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return FairyLights.proxy.getFairyLightsFastenerPickBlock(target, world, x, y, z, this);
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float fromBlockX, float fromBlockY, float fromBlockZ) {
        ItemStack heldItemStack = player.func_70694_bm();
        if (heldItemStack != null && heldItemStack.func_77973_b() == FairyLights.fairyLights) {
            PlayerData data = PlayerData.getPlayerData(player);
            if (data.hasLastClicked()) {
                TileEntity tileEntityTo;
                Point3i lastClicked = data.getLastClicked();
                TileEntity tileEntity = world.func_72796_p(lastClicked.x, lastClicked.y, lastClicked.z);
                if (tileEntity != (tileEntityTo = world.func_72796_p(x, y, z)) && tileEntity instanceof TileEntityFairyLightsFastener && tileEntityTo instanceof TileEntityFairyLightsFastener) {
                    if (!world.field_72995_K) {
                        TileEntityFairyLightsFastener to = (TileEntityFairyLightsFastener)tileEntity;
                        TileEntityFairyLightsFastener from = (TileEntityFairyLightsFastener)tileEntityTo;
                        from.connectWith(to, heldItemStack.func_77978_p());
                        to.removeConnection((Entity)player);
                        data.setUnknownLastClicked();
                        if (!player.field_71075_bZ.field_75098_d) {
                            --heldItemStack.field_77994_a;
                        }
                    }
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    data.setLastClicked(x, y, z);
                    TileEntityFairyLightsFastener tileEntity = (TileEntityFairyLightsFastener)world.func_72796_p(x, y, z);
                    tileEntity.connectWith(player, heldItemStack.func_77978_p());
                }
                return true;
            }
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighbor) {
        int data = world.func_72805_g(x, y, z);
        ForgeDirection direction = DATA_TO_DIRECTION[data];
        Block blockOn = Block.field_71973_m[world.func_72798_a(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ)];
        if (!(blockOn != null && (blockOn.isBlockSolidOnSide(world, x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction) || blockOn instanceof BlockHalfSlab && direction.offsetY == 0 || blockOn instanceof BlockLeaves || blockOn instanceof BlockStairs))) {
            this.func_71897_c(world, x, y, z, data, 0);
            world.func_94571_i(x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        Point3f offset = this.getOffsetForData(data, 0.0f);
        this.func_71905_a(offset.x, offset.y, offset.z, offset.x + 0.25f, offset.y + 0.25f, offset.z + 0.25f);
    }
}

