/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model;

import com.pau101.fairylights.block.BlockFairyLightsFastener;
import com.pau101.fairylights.client.model.ModelScalableRenderer;
import com.pau101.fairylights.tileentity.TileEntityFairyLightsFastener;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.Light;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ModelFairyLights
extends ModelBase {
    private ModelRenderer fastenerModel = new ModelRenderer((ModelBase)this, 0, 0);
    private ModelScalableRenderer stringModel;
    private ModelScalableRenderer lightModel;

    public ModelFairyLights() {
        this.fastenerModel.func_78789_a(-2.0f, -8.0f, -2.0f, 4, 4, 4);
        this.fastenerModel.func_78793_a(8.0f, 8.0f, 8.0f);
        this.stringModel = new ModelScalableRenderer(this, 0, 8);
        this.stringModel.addBox(-1.0f, -1.0f, 0.0f, 2, 2, 1);
        this.lightModel = new ModelScalableRenderer(this, 0, 11);
        this.lightModel.addBox(-1.5f, -1.5f, -1.5f, 3, 3, 3);
    }

    public void renderConnections(TileEntityFairyLightsFastener fairyLightsFastener, float t) {
        World world = fairyLightsFastener.func_70314_l();
        List<TileEntityFairyLightsFastener.Connection> connections = fairyLightsFastener.getConnectionsForRender();
        GL11.glPushMatrix();
        Point3f offset = ((BlockFairyLightsFastener)fairyLightsFastener.func_70311_o()).getOffsetForData(fairyLightsFastener.func_70322_n(), 0.125f);
        GL11.glTranslatef((float)offset.x, (float)offset.y, (float)offset.z);
        int blockBrightness = world.func_72802_i(fairyLightsFastener.field_70329_l, fairyLightsFastener.field_70330_m, fairyLightsFastener.field_70327_n, 0);
        int sunlight = blockBrightness % 65536;
        int moonlight = blockBrightness / 65536;
        GL11.glDisable((int)32826);
        for (TileEntityFairyLightsFastener.Connection connection : connections) {
            Point3f to = connection.getTo();
            int toBlockBrightness = world.func_72802_i(MathHelper.func_76141_d((float)to.x), MathHelper.func_76141_d((float)to.y), MathHelper.func_76141_d((float)to.z), 0);
            int toSunlight = toBlockBrightness % 65536;
            int toMoonlight = toBlockBrightness / 65536;
            boolean tight = connection.isTight();
            Segment[] segments = connection.getCatenary().getSegments();
            Catenary prevCatenary = connection.getPrevCatenary();
            Segment[] segmentsOld = null;
            if (prevCatenary != null) {
                segmentsOld = prevCatenary.getSegments();
            }
            GL11.glColor3f((float)0.2f, (float)0.2f, (float)0.2f);
            for (int i = 0; i < segments.length; ++i) {
                float v = (float)i / (float)segments.length;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)sunlight * (1.0f - v) + (float)toSunlight * v), (float)((float)moonlight * (1.0f - v) + (float)toMoonlight * v));
                Segment segment = segments[i];
                Vector3f rotation = segment.getRotation();
                if (segmentsOld != null && i < segmentsOld.length) {
                    rotation.interpolate(segmentsOld[i].getRotation(), 1.0f - t, true);
                }
                this.stringModel.rotateAngleX = rotation.y;
                this.stringModel.rotateAngleY = rotation.x;
                float length = segment.getLength();
                if (segmentsOld != null && i < segmentsOld.length) {
                    length = length * t + segmentsOld[i].getLength() * (1.0f - t);
                }
                this.stringModel.scaleZ = length;
                Point3f vertex = segment.getVertex();
                if (segmentsOld != null && i < segmentsOld.length) {
                    vertex.interpolate(segmentsOld[i].getVertex(), 1.0f - t);
                }
                this.stringModel.setRotationPoint(vertex.x, vertex.y, vertex.z);
                this.stringModel.render(0.0625f);
            }
            Light[] lightPoints = connection.getLightPoints();
            Light[] lightPointsOld = connection.getPrevLightPoints();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            for (int i = 0; i < lightPoints.length; ++i) {
                Light light = lightPoints[i];
                Point3f point = light.getPoint();
                Vector3f color = light.getLight();
                Vector3f rotation = light.getRotation();
                float brightness = 1.0f;
                if (lightPointsOld != null && i < lightPointsOld.length) {
                    point.interpolate(lightPointsOld[i].getPoint(), 1.0f - t);
                    rotation.interpolate(lightPointsOld[i].getRotation(), 1.0f - t, true);
                    brightness = lightPointsOld[i].getBrightness() * (1.0f - t) + light.getBrightness() * t;
                }
                this.lightModel.rotateAngleX = rotation.y;
                this.lightModel.rotateAngleY = rotation.x;
                this.lightModel.rotateAngleZ = rotation.z;
                this.lightModel.offsetX = point.x / 16.0f;
                this.lightModel.offsetY = point.y / 16.0f;
                this.lightModel.offsetZ = point.z / 16.0f;
                this.lightModel.aftMoveY = Math.abs(rotation.y) == 1.5707964f || tight ? 0.0f : -0.1375f;
                this.lightModel.scaleZ = 1.0f;
                this.lightModel.scaleY = 1.0f;
                this.lightModel.scaleX = 1.0f;
                float[] hsb = new float[3];
                Color.RGBtoHSB((int)(color.x * 255.0f + 0.5f), (int)(color.y * 255.0f + 0.5f), (int)(color.z * 255.0f + 0.5f), hsb);
                hsb[2] = brightness;
                int colorRGB = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                float cr = (float)(colorRGB >> 16 & 0xFF) / 255.0f;
                float cg = (float)(colorRGB >> 8 & 0xFF) / 255.0f;
                float cb = (float)(colorRGB & 0xFF) / 255.0f;
                GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)1.0f);
                float b = Math.max(brightness * 240.0f, (float)sunlight);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)b, (float)moonlight);
                this.lightModel.render(0.0625f);
                int maxBrightness = 3;
                float expand = 1.3f;
                Color.RGBtoHSB((int)(color.x * 255.0f + 0.5f), (int)(color.y * 255.0f + 0.5f), (int)(color.z * 255.0f + 0.5f), hsb);
                if (hsb[1] > 0.0f) {
                    hsb[1] = brightness;
                }
                hsb[2] = 1.0f;
                colorRGB = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                cr = (float)(colorRGB >> 16 & 0xFF) / 255.0f;
                cg = (float)(colorRGB >> 8 & 0xFF) / 255.0f;
                cb = (float)(colorRGB & 0xFF) / 255.0f;
                GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)(brightness * 0.15f + 0.1f));
                for (int bright = 1; bright < maxBrightness; ++bright) {
                    b = (float)bright / (float)maxBrightness;
                    this.lightModel.scaleY = this.lightModel.scaleZ = 1.0f + b * expand;
                    this.lightModel.scaleX = this.lightModel.scaleZ;
                    this.lightModel.render(0.0625f);
                }
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
        GL11.glEnable((int)32826);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void renderFastener(int data) {
        this.fastenerModel.field_78808_h = (float)(data & 3) * (float)Math.PI / 2.0f;
        this.fastenerModel.field_78795_f = (float)(data >> 2 & 3) * (float)Math.PI / 2.0f;
        this.fastenerModel.func_78785_a(0.0625f);
    }
}

