/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.item.crafting;

import com.pau101.fairylights.FairyLights;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RecipeFairyLights
implements IRecipe {
    private int recipeWidth;
    private int recipeHeight;
    private ItemStack[][] recipeItems;
    private Item outputItem;
    private ItemStack[] itemContained;
    private ItemStack recipeOutput;

    public RecipeFairyLights() {
        int i;
        Object[] recipe = new Object[]{"I-I", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('-'), new Item[]{Item.field_77683_K, Item.field_77669_D}};
        this.outputItem = FairyLights.fairyLights;
        String recipeString = "";
        int slot = 0;
        if (recipe[slot] instanceof String[]) {
            String[] recipeRows = (String[])recipe[slot++];
            for (i = 0; i < recipeRows.length; ++i) {
                String recipeRow = recipeRows[i];
                ++this.recipeHeight;
                this.recipeWidth = recipeRow.length();
                recipeString = recipeString + recipeRow;
            }
        } else {
            while (recipe[slot] instanceof String) {
                String recipeRow = (String)recipe[slot++];
                ++this.recipeHeight;
                this.recipeWidth = recipeRow.length();
                recipeString = recipeString + recipeRow;
            }
        }
        HashMap ingredientMap = new HashMap();
        while (slot < recipe.length) {
            Character character = (Character)recipe[slot];
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            if (recipe[slot + 1] instanceof Item) {
                itemStacks.add(new ItemStack((Item)recipe[slot + 1]));
            } else if (recipe[slot + 1] instanceof Block) {
                itemStacks.add(new ItemStack((Block)recipe[slot + 1], 1, Short.MAX_VALUE));
            } else if (recipe[slot + 1] instanceof ItemStack) {
                itemStacks.add((ItemStack)recipe[slot + 1]);
            } else if (recipe[slot + 1] instanceof Object[]) {
                Object[] objects = (Object[])recipe[slot + 1];
                for (int i2 = 0; i2 < objects.length; ++i2) {
                    Object object = objects[i2];
                    if (object instanceof Item) {
                        itemStacks.add(new ItemStack((Item)object));
                        continue;
                    }
                    if (object instanceof Block) {
                        itemStacks.add(new ItemStack((Block)object, 1, Short.MAX_VALUE));
                        continue;
                    }
                    if (!(object instanceof ItemStack)) continue;
                    itemStacks.add((ItemStack)object);
                }
            }
            ingredientMap.put(character, itemStacks);
            slot += 2;
        }
        this.recipeItems = new ItemStack[this.recipeWidth * this.recipeHeight][];
        for (i = 0; i < this.recipeWidth * this.recipeHeight; ++i) {
            char character = recipeString.charAt(i);
            if (ingredientMap.containsKey(Character.valueOf(character))) {
                List itemStackOptions = (List)ingredientMap.get(Character.valueOf(character));
                this.recipeItems[i] = new ItemStack[itemStackOptions.size()];
                for (int n = 0; n < this.recipeItems[i].length; ++n) {
                    this.recipeItems[i][n] = ((ItemStack)itemStackOptions.get(n)).func_77946_l();
                }
                continue;
            }
            this.recipeItems[i] = null;
        }
    }

    private boolean checkMatch(InventoryCrafting inventoryCrafting, int offsetX, int offsetY, boolean mirror) {
        this.itemContained = new ItemStack[this.recipeWidth * this.recipeHeight];
        for (int x = 0; x < this.recipeWidth; ++x) {
            for (int y = 0; y < this.recipeHeight; ++y) {
                ItemStack[] itemStackinInv;
                int index;
                if (mirror) {
                    index = this.recipeWidth - x - 1 + y * this.recipeWidth;
                    itemStackinInv = this.recipeItems[index];
                } else {
                    index = x + y * this.recipeWidth;
                    itemStackinInv = this.recipeItems[index];
                }
                ItemStack itemStack = inventoryCrafting.func_70463_b(x + offsetX, y + offsetY);
                if (itemStack != null && this.sharesItem(index, itemStack, itemStackinInv)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean sharesItem(int index, ItemStack itemStack, ItemStack ... options) {
        Item item = itemStack.func_77973_b();
        int damage = itemStack.func_77960_j();
        for (int i = 0; i < options.length; ++i) {
            ItemStack option = options[i];
            if (item != option.func_77973_b() || damage == Short.MAX_VALUE || damage != option.func_77960_j()) continue;
            this.itemContained[index] = option;
            return true;
        }
        return false;
    }

    private boolean containsRecipe(InventoryCrafting inventoryCrafting) {
        for (int x = 0; x <= 3 - this.recipeWidth; ++x) {
            for (int y = 0; y <= 3 - this.recipeHeight; ++y) {
                if (!this.checkMatch(inventoryCrafting, x, y, true) && !this.checkMatch(inventoryCrafting, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return this.recipeOutput.func_77946_l();
    }

    private void getDetails(InventoryCrafting inventoryCrafting, World world, boolean rewriteLights) {
        this.recipeOutput = new ItemStack(this.outputItem, rewriteLights ? 1 : 2);
        NBTTagCompound tagCompound = new NBTTagCompound("tag");
        NBTTagList tagList = new NBTTagList();
        boolean twinkle = false;
        int size = inventoryCrafting.func_70302_i_();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack itemStack = inventoryCrafting.func_70301_a(slot);
            if (itemStack == null) continue;
            Item item = itemStack.func_77973_b();
            if (item == Item.field_77756_aW) {
                NBTTagCompound patternCompound = new NBTTagCompound();
                patternCompound.func_74774_a("color", (byte)itemStack.func_77960_j());
                tagList.func_74742_a((NBTBase)patternCompound);
                continue;
            }
            if (item == Item.field_77751_aT) {
                if (twinkle) {
                    this.recipeOutput = null;
                    return;
                }
                twinkle = true;
                continue;
            }
            if (!this.isForeignItemFromRecipe(item) || item == FairyLights.fairyLights || rewriteLights) continue;
            this.recipeOutput = null;
            return;
        }
        if (tagList.func_74745_c() > 0) {
            tagCompound.func_74782_a("pattern", (NBTBase)tagList);
        }
        tagCompound.func_74757_a("twinkle", twinkle);
        tagCompound.func_74757_a("tight", this.itemContained[1] != null && this.itemContained[1].func_77973_b() == Item.field_77669_D);
        this.recipeOutput.func_77982_d(tagCompound);
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public int func_77570_a() {
        return 10;
    }

    private boolean inventoryContains(IInventory inventory, Item item) {
        int size = inventory.func_70302_i_();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack itemStack = inventory.func_70301_a(slot);
            if (itemStack == null || itemStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    private boolean isForeignItemFromRecipe(Item item) {
        for (int i = 0; i < this.recipeItems.length; ++i) {
            for (int n = 0; n < this.recipeItems[i].length; ++n) {
                ItemStack itemStack = this.recipeItems[i][n];
                if (itemStack == null || itemStack.func_77973_b() != item) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        this.recipeOutput = null;
        if (this.containsRecipe(inventoryCrafting)) {
            this.getDetails(inventoryCrafting, world, false);
        } else if (this.inventoryContains((IInventory)inventoryCrafting, FairyLights.fairyLights)) {
            this.getDetails(inventoryCrafting, world, true);
        }
        return this.recipeOutput != null;
    }
}

