/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.network;

import com.google.common.collect.HashBiMap;
import com.pau101.fairylights.network.FLPacket;
import com.pau101.fairylights.network.play.server.S00FLPacketJingle;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class FLNetworkManager
implements IPacketHandler {
    public static HashBiMap<Integer, Class<? extends FLPacket>> packetMap = HashBiMap.create();
    private String channelName;

    public FLNetworkManager(String channelName) {
        this.channelName = channelName;
        NetworkRegistry.instance().registerChannel((IPacketHandler)this, channelName);
    }

    private Packet250CustomPayload getInProxy(FLPacket modPacket) throws IOException {
        int id = (Integer)packetMap.inverse().get(modPacket.getClass());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(bytes);
        stream.writeInt(id);
        modPacket.writePacketData(stream);
        Packet250CustomPayload packet = new Packet250CustomPayload(this.channelName, bytes.toByteArray());
        return packet;
    }

    public void onPacketData(INetworkManager networkManager, Packet250CustomPayload proxyPacket, Player player) {
        try {
            int id;
            FLPacket packet;
            DataInputStream stream;
            int readableBytes;
            if (this.channelName.equals(proxyPacket.field_73630_a) && (readableBytes = (stream = new DataInputStream(new ByteArrayInputStream(proxyPacket.field_73629_c))).available()) != 0 && (packet = FLPacket.generatePacket(packetMap, id = stream.readInt())) != null) {
                packet.readPacketData(stream);
                packet.processPacket(networkManager);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendPacketToClient(FLPacket modPacket, Player player) {
        try {
            PacketDispatcher.sendPacketToPlayer((Packet)this.getInProxy(modPacket), (Player)player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendPacketToClientsWatchingChunk(int x, int z, World world, FLPacket packet, Entity ... exceptions) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
            boolean found = false;
            if (exceptions != null) {
                for (Entity e : exceptions) {
                    if (e != player) continue;
                    found = true;
                }
            }
            if (found || player.field_70170_p != world || !player.func_71121_q().func_73040_p().func_72694_a(player, chunkX, chunkZ)) continue;
            this.sendPacketToClient(packet, (Player)player);
        }
    }

    public void sendPacketToServer(FLPacket modPacket) {
    }

    static {
        packetMap.put((Object)0, S00FLPacketJingle.class);
    }
}

