/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import net.minecraft.util.MathHelper;

public class Segment {
    private Point3f start;
    private Point3f to;
    private Vector3f rotation;
    private float length;

    public Segment(Point3f vertex) {
        this.start = vertex;
    }

    public void connectTo(Point3f to) {
        this.to = to;
        this.length = this.start.distance(to);
        Point3f delta = new Point3f(this.start);
        delta.sub(to);
        float rotationYaw = (float)(-Math.atan2(delta.z, delta.x)) - 1.5707964f;
        float rotationPitch = (float)Math.atan2(delta.y, MathHelper.func_76129_c((float)(delta.x * delta.x + delta.z * delta.z)));
        this.rotation = new Vector3f(rotationYaw, rotationPitch, 0.0f);
    }

    public float getLength() {
        return this.length;
    }

    public Vector3f getRotation() {
        return new Vector3f(this.rotation);
    }

    public Point3f getVertex() {
        return new Point3f(this.start);
    }

    public Point3f pointAt(float t) {
        Point3f interpolated = new Point3f(this.start);
        interpolated.interpolate(this.to, t);
        return interpolated;
    }

    public void setLength(float length) {
        this.length = length;
    }
}

