/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.world;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.config.Configurator;
import com.pau101.fairylights.eggs.Jingle;
import com.pau101.fairylights.eggs.JinglePlayer;
import com.pau101.fairylights.network.play.server.S00FLPacketJingle;
import com.pau101.fairylights.player.PlayerData;
import com.pau101.fairylights.tileentity.TileEntityFairyLightsFastener;
import com.pau101.fairylights.util.Light;
import com.pau101.fairylights.util.vectormath.Point3f;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TickHandler
implements ITickHandler {
    private Random random = new Random();
    private float jingleProbability = 1.6666666E-4f;

    private List<Point3f> getLightPoints(Map<TileEntityFairyLightsFastener, List<TileEntityFairyLightsFastener.Connection>> feasibleConnections, TileEntityFairyLightsFastener fastener) {
        for (TileEntityFairyLightsFastener.Connection connection : fastener.getConnections()) {
            Light[] lightPoints;
            int range;
            if (!connection.isOrigin() || (range = (lightPoints = connection.getLightPoints()) == null ? 0 : lightPoints.length) < Jingle.getMinRange()) continue;
            if (connection.jinglePlayer == null) {
                if (feasibleConnections.containsKey((Object)fastener)) {
                    feasibleConnections.get((Object)fastener).add(connection);
                } else {
                    ArrayList<TileEntityFairyLightsFastener.Connection> connections = new ArrayList<TileEntityFairyLightsFastener.Connection>();
                    connections.add(connection);
                    feasibleConnections.put(fastener, connections);
                }
                return new ArrayList<Point3f>(0);
            }
            ArrayList<Point3f> points = new ArrayList<Point3f>();
            for (Light light : lightPoints) {
                points.add(light.getAbsolutePoint(fastener));
            }
            return points;
        }
        return null;
    }

    public boolean isTooCloseTo(TileEntityFairyLightsFastener fastener, Light[] lights, List<Point3f> playingSources) {
        for (Light light : lights) {
            for (Point3f point : playingSources) {
                if (!(light.getAbsolutePoint(fastener).distance(point) <= (float)Configurator.jingleAmplitude)) continue;
                return true;
            }
        }
        return false;
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD, TickType.SERVER);
    }

    public String getLabel() {
        return null;
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            World world = (World)tickData[0];
            if (world.func_82737_E() % 200L == 0L) {
                PlayerData.takeOutTheGarbage(world);
            }
            if (FairyLights.christmasDay.isOcurringNow() && !world.field_72995_K && Configurator.jingleEnabled && this.random.nextFloat() <= this.jingleProbability) {
                int lightOffset;
                Jingle jingle;
                List connections;
                TileEntityFairyLightsFastener fastener;
                List tileEntities = world.field_73009_h;
                ArrayList<Point3f> playingSources = new ArrayList<Point3f>();
                HashMap<TileEntityFairyLightsFastener, List<TileEntityFairyLightsFastener.Connection>> feasibleConnections = new HashMap<TileEntityFairyLightsFastener, List<TileEntityFairyLightsFastener.Connection>>();
                for (TileEntity tileEntity : tileEntities) {
                    TileEntityFairyLightsFastener fastener2;
                    List<Point3f> pointsToAdd;
                    if (!(tileEntity instanceof TileEntityFairyLightsFastener) || (pointsToAdd = this.getLightPoints(feasibleConnections, fastener2 = (TileEntityFairyLightsFastener)tileEntity)) == null || pointsToAdd.size() <= 0) continue;
                    playingSources.addAll(pointsToAdd);
                }
                Iterator feasibleFasteners = feasibleConnections.keySet().iterator();
                while (feasibleFasteners.hasNext()) {
                    fastener = (TileEntityFairyLightsFastener)((Object)feasibleFasteners.next());
                    connections = (List)feasibleConnections.get((Object)fastener);
                    Iterator connectionIterator = connections.iterator();
                    while (connectionIterator.hasNext()) {
                        TileEntityFairyLightsFastener.Connection connection = (TileEntityFairyLightsFastener.Connection)connectionIterator.next();
                        if (!this.isTooCloseTo(fastener, connection.getLightPoints(), playingSources)) continue;
                        connectionIterator.remove();
                    }
                    if (connections.size() != 0) continue;
                    feasibleFasteners.remove();
                }
                if (feasibleConnections.size() == 0) {
                    return;
                }
                fastener = feasibleConnections.keySet().toArray(new TileEntityFairyLightsFastener[0])[this.random.nextInt(feasibleConnections.size())];
                connections = (List)feasibleConnections.get((Object)fastener);
                TileEntityFairyLightsFastener.Connection connection = (TileEntityFairyLightsFastener.Connection)connections.get(this.random.nextInt(connections.size()));
                int index = fastener.getConnections().indexOf(connection);
                Light[] lightPoints = connection.getLightPoints();
                if (lightPoints != null && (jingle = Jingle.getRandomJingle(lightOffset = lightPoints.length)) != null) {
                    lightOffset = lightOffset / 2 - jingle.getRange() / 2;
                    connection.setJinglePlayer(new JinglePlayer(jingle, lightOffset));
                    FairyLights.networkManager.sendPacketToClientsWatchingChunk(fastener.field_70329_l, fastener.field_70327_n, world, new S00FLPacketJingle(fastener, index, lightOffset, jingle), new Entity[0]);
                }
            }
        }
        if (type.contains(TickType.SERVER)) {
            PlayerData.update();
        }
    }
}

