/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.block;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.item.ItemConnection;
import com.pau101.fairylights.player.PlayerData;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.tileentity.connection.ConnectionPlayer;
import com.pau101.fairylights.util.mc.EnumFacing;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Point3i;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockConnectionFastener
extends BlockContainer {
    public static final int[] SIDE_TO_DATA = new int[]{2, 0, 12, 4, 1, 3};
    private static final ForgeDirection[] DATA_TO_DIRECTION = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.NORTH, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN};
    public static final EnumFacing[] DATA_TO_FACING = new EnumFacing[]{EnumFacing.UP, EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP};

    public BlockConnectionFastener() {
        super(Material.field_151594_q);
        this.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 0.25f, 0.625f);
        this.func_149658_d("fairylights:fastener");
    }

    public BlockConnectionFastener(Material material) {
        super(material);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityConnectionFastener fastener = (TileEntityConnectionFastener)world.func_147438_o(x, y, z);
        if (fastener == null) {
            return;
        }
        Iterator<Connection> connectionIterator = fastener.getConnections().iterator();
        float offsetX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        while (connectionIterator.hasNext()) {
            Connection connection = connectionIterator.next();
            if (connection instanceof ConnectionPlayer) continue;
            ItemStack itemStack = new ItemStack((Item)connection.getType().getItem(), 1);
            NBTTagCompound tagCompound = new NBTTagCompound();
            connection.writeDetailsToNBT(tagCompound);
            if (!tagCompound.func_82582_d()) {
                itemStack.func_77982_d(tagCompound);
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), itemStack);
            float v = 0.05f;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)v;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)v + (double)0.2f;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)v;
            world.func_72838_d((Entity)entityItem);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public TileEntity func_149915_a(World world, int data) {
        return new TileEntityConnectionFastener();
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public Item func_149650_a(int data, Random random, int fortune) {
        return null;
    }

    public Point3f getOffsetForData(int data, float offset) {
        Point3f offsetPoint = new Point3f(offset, offset, offset);
        switch (data) {
            case 2: {
                offsetPoint.y += 0.75f;
            }
            case 0: {
                offsetPoint.x += 0.375f;
                offsetPoint.z += 0.375f;
                break;
            }
            case 1: {
                offsetPoint.x += 0.75f;
            }
            case 3: {
                offsetPoint.z += 0.375f;
                offsetPoint.y += 0.375f;
                break;
            }
            case 12: {
                offsetPoint.z += 0.75f;
            }
            case 4: {
                offsetPoint.x += 0.375f;
                offsetPoint.y += 0.375f;
            }
        }
        return offsetPoint;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return FairyLights.proxy.getFairyLightsFastenerPickBlock(target, world, x, y, z, this);
    }

    public int func_149645_b() {
        return 0;
    }

    public boolean func_149686_d() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fromBlockX, float fromBlockY, float fromBlockZ) {
        ItemStack heldItemStack = player.func_70694_bm();
        if (heldItemStack != null && heldItemStack.func_77973_b() instanceof ItemConnection) {
            ItemConnection item = (ItemConnection)heldItemStack.func_77973_b();
            PlayerData data = PlayerData.getPlayerData(player);
            if (data.hasLastClicked()) {
                TileEntity tileEntityTo;
                Point3i lastClicked = data.getLastClicked();
                TileEntity tileEntity = world.func_147438_o(lastClicked.x, lastClicked.y, lastClicked.z);
                if (tileEntity != (tileEntityTo = world.func_147438_o(x, y, z)) && tileEntity instanceof TileEntityConnectionFastener && tileEntityTo instanceof TileEntityConnectionFastener) {
                    if (!world.field_72995_K) {
                        TileEntityConnectionFastener to = (TileEntityConnectionFastener)tileEntity;
                        TileEntityConnectionFastener from = (TileEntityConnectionFastener)tileEntityTo;
                        from.connectWith(to, item.getConnectionType(), heldItemStack.func_77978_p());
                        to.removeConnection((Entity)player);
                        data.setUnknownLastClicked();
                        if (!player.field_71075_bZ.field_75098_d) {
                            --heldItemStack.field_77994_a;
                        }
                    }
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    data.setLastClicked(x, y, z);
                    TileEntityConnectionFastener tileEntity = (TileEntityConnectionFastener)world.func_147438_o(x, y, z);
                    tileEntity.connectWith(player, item.getConnectionType(), heldItemStack.func_77978_p());
                }
                return true;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int data = world.func_72805_g(x, y, z);
        ForgeDirection direction = DATA_TO_DIRECTION[data];
        Block blockOn = world.func_147439_a(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ);
        if (!(world.isSideSolid(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction) || blockOn instanceof BlockSlab && direction.offsetY == 0 || blockOn instanceof BlockLeaves || blockOn instanceof BlockStairs)) {
            this.func_149697_b(world, x, y, z, data, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        Point3f offset = this.getOffsetForData(data, 0.0f);
        this.func_149676_a(offset.x, offset.y, offset.z, offset.x + 0.25f, offset.y + 0.25f, offset.z + 0.25f);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int meta) {
        return true;
    }
}

