/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.connection.ConnectionLogic;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class ModelConnection<T extends ConnectionLogic>
extends ModelBase {
    public ModelConnection() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void render(TileEntityConnectionFastener fastener, T logic, World world, int skylight, int moonlight, float delta) {
        this.renderCord(logic, world, skylight, moonlight, delta);
    }

    public void renderCord(T connectionLogic, World world, int sunlight, int moonlight, float delta) {
        Connection connection = ((ConnectionLogic)connectionLogic).getConnection();
        Point3f to = connection.getTo();
        int toBlockBrightness = world.func_72802_i(MathHelper.func_76141_d((float)to.x), MathHelper.func_76141_d((float)to.y), MathHelper.func_76141_d((float)to.z), 0);
        int toSunlight = toBlockBrightness % 65536;
        int toMoonlight = toBlockBrightness / 65536;
        Segment[] segments = connection.getCatenary().getSegments();
        Catenary prevCatenary = connection.getPrevCatenary();
        Segment[] segmentsOld = null;
        if (prevCatenary != null) {
            segmentsOld = prevCatenary.getSegments();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        for (int i = 0; i < segments.length; ++i) {
            float v = (float)i / (float)segments.length;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)sunlight * (1.0f - v) + (float)toSunlight * v), (float)((float)moonlight * (1.0f - v) + (float)toMoonlight * v));
            Segment segment = segments[i];
            Vector3f rotation = segment.getRotation();
            if (segmentsOld != null && i < segmentsOld.length) {
                rotation.interpolate(segmentsOld[i].getRotation(), 1.0f - delta, true);
            }
            float length = segment.getLength();
            if (segmentsOld != null && i < segmentsOld.length) {
                length = length * delta + segmentsOld[i].getLength() * (1.0f - delta);
            }
            Point3f vertex = segment.getVertex();
            if (segmentsOld != null && i < segmentsOld.length) {
                vertex.interpolate(segmentsOld[i].getVertex(), 1.0f - delta);
            }
            this.renderSegment(connectionLogic, i, rotation.y, rotation.x, length, vertex.x, vertex.y, vertex.z, delta);
        }
        GL11.glEnable((int)32826);
    }

    protected abstract void renderSegment(T var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public final ModelRenderer func_85181_a(Random rand) {
        throw new UnsupportedOperationException();
    }

    public final TextureOffset func_78084_a(String partName) {
        throw new UnsupportedOperationException();
    }

    public final void func_78088_a(Entity entity, float speed, float swing, float entityAge, float yaw, float pitch, float scale) {
        throw new UnsupportedOperationException();
    }

    public final void func_78086_a(EntityLivingBase entity, float yaw, float pitch, float delta) {
        throw new UnsupportedOperationException();
    }

    public final void func_78087_a(float speed, float swing, float entityAge, float yaw, float pitch, float scale, Entity entity) {
        throw new UnsupportedOperationException();
    }

    protected final void func_78085_a(String partName, int x, int y) {
        throw new UnsupportedOperationException();
    }
}

