/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.client.model.lights.ModelLight;
import com.pau101.fairylights.client.model.lights.ModelLightFairy;
import com.pau101.fairylights.client.model.lights.ModelLightFlower;
import com.pau101.fairylights.client.model.lights.ModelLightGhost;
import com.pau101.fairylights.client.model.lights.ModelLightIcicle;
import com.pau101.fairylights.client.model.lights.ModelLightJackOLantern;
import com.pau101.fairylights.client.model.lights.ModelLightLuxoBall;
import com.pau101.fairylights.client.model.lights.ModelLightMeteor;
import com.pau101.fairylights.client.model.lights.ModelLightOil;
import com.pau101.fairylights.client.model.lights.ModelLightOrb;
import com.pau101.fairylights.client.model.lights.ModelLightOrnate;
import com.pau101.fairylights.client.model.lights.ModelLightPaper;
import com.pau101.fairylights.client.model.lights.ModelLightSkull;
import com.pau101.fairylights.client.model.lights.ModelLightSnowflake;
import com.pau101.fairylights.client.model.lights.ModelLightSpider;
import com.pau101.fairylights.client.model.lights.ModelLightWeedwoodLantern;
import com.pau101.fairylights.client.model.lights.ModelLightWitch;
import com.pau101.fairylights.connection.ConnectionLogicFairyLights;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ModelConnectionFairyLights
extends ModelConnection<ConnectionLogicFairyLights> {
    private AdvancedModelRenderer cordModel;
    private ModelLight[] lightModels = new ModelLight[]{new ModelLightFairy(), new ModelLightPaper(), new ModelLightOrb(), new ModelLightFlower(), new ModelLightOrnate(), new ModelLightOil(), new ModelLightLuxoBall(), new ModelLightJackOLantern(), new ModelLightSkull(), new ModelLightGhost(), new ModelLightSpider(), new ModelLightWitch(), new ModelLightWeedwoodLantern(), new ModelLightSnowflake(), new ModelLightIcicle(), new ModelLightMeteor()};

    public ModelConnectionFairyLights() {
        this.cordModel = new AdvancedModelRenderer(this, 0, 0);
        this.cordModel.addBox(-1.0f, -1.0f, 0.0f, 2, 2, 1);
    }

    @Override
    public void render(TileEntityConnectionFastener fastener, ConnectionLogicFairyLights logic, World world, int skylight, int moonlight, float delta) {
        super.render(fastener, logic, world, skylight, moonlight, delta);
        Light[] lightPoints = logic.getLightPoints();
        Light[] lightPointsOld = logic.getPrevLightPoints();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        int fastenerRotation = fastener.func_145832_p();
        for (int i = 0; i < lightPoints.length; ++i) {
            boolean vert;
            Light light = lightPoints[i];
            Point3f point = light.getPoint();
            Vector3f color = light.getLight();
            Vector3f rotation = light.getRotation();
            float brightness = 1.0f;
            if (lightPointsOld != null && i < lightPointsOld.length) {
                point.interpolate(lightPointsOld[i].getPoint(), 1.0f - delta);
                rotation.interpolate(lightPointsOld[i].getRotation(), 1.0f - delta, true);
                brightness = light.getBrightness(delta);
            }
            ModelLight lightModel = this.lightModels[light.getVariant().ordinal()];
            lightModel.setOffsets(point.x / 16.0f, point.y / 16.0f, point.z / 16.0f);
            float rotationOffset = 0.0f;
            boolean bl = vert = Math.abs(rotation.y) == 1.5707964f;
            if (vert) {
                switch (fastenerRotation) {
                    case 2: {
                        rotationOffset = (float)(-Math.PI);
                        break;
                    }
                    case 3: {
                        rotationOffset = -1.5707964f;
                        break;
                    }
                    case 4: {
                        rotationOffset = 1.5707964f;
                    }
                }
            }
            lightModel.setAfts(0.0f, -0.1375f, 0.0f);
            lightModel.setRotationAngles(lightModel.shouldParallelCord() ? rotation.y : (vert ? 0.3f : 0.0f), rotation.x + rotationOffset, rotation.z);
            lightModel.setScale(1.0f);
            lightModel.render(world, light, 0.0625f, color, moonlight, skylight, brightness, i, delta);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    @Override
    protected void renderSegment(ConnectionLogicFairyLights fairylights, int index, float angleX, float angleY, float length, float x, float y, float z, float delta) {
        this.cordModel.field_78795_f = angleX;
        this.cordModel.field_78796_g = angleY;
        this.cordModel.scaleZ = length;
        this.cordModel.func_78793_a(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
    }
}

