/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.client.renderer.ConnectionRenderer;
import com.pau101.fairylights.connection.ConnectionLogicGarland;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.tileentity.connection.ConnectionPlayer;
import com.pau101.fairylights.util.MathUtils;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ModelConnectionGarland
extends ModelConnection<ConnectionLogicGarland> {
    private static final int RING_COUNT = 8;
    private static final float RINGS_PER_METER = 4.0f;
    private static final float[] RANDOM_VALUES = new float[32];
    private AdvancedModelRenderer cordModel = new AdvancedModelRenderer(this, 39, 0);
    private int ringId = -1;
    private int uniquifier;

    public ModelConnectionGarland() {
        this.cordModel.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 1);
    }

    private void generateGarlandRings() {
        this.ringId = GLAllocation.func_74526_a((int)8);
        for (int i = 0; i < 8; ++i) {
            GL11.glNewList((int)(this.ringId + i), (int)4864);
            ConnectionRenderer.render3DTexture(8, 8, i * 8, 64);
            GL11.glEndList();
        }
    }

    @Override
    public void renderCord(ConnectionLogicGarland connectionLogic, World world, int sunlight, int moonlight, float delta) {
        Connection connection = connectionLogic.getConnection();
        TileEntityConnectionFastener fastener = connection.getFastener();
        this.uniquifier = (fastener.field_145848_d + fastener.field_145849_e * 31) * 31 + fastener.field_145851_c;
        this.uniquifier = connection instanceof ConnectionPlayer ? this.uniquifier * 31 + ((ConnectionPlayer)connection).getPlayerUUID().hashCode() : this.uniquifier * 31 + connection.getTo().hashCode();
        super.renderCord(connectionLogic, world, sunlight, moonlight, delta);
    }

    @Override
    protected void renderSegment(ConnectionLogicGarland garland, int index, float angleX, float angleY, float length, float x, float y, float z, float delta) {
        if (this.ringId == -1) {
            this.generateGarlandRings();
        }
        this.cordModel.field_78795_f = angleX;
        this.cordModel.field_78796_g = angleY;
        this.cordModel.scaleZ = length;
        this.cordModel.func_78793_a(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x / 16.0f), (float)(y / 16.0f), (float)(z / 16.0f));
        GL11.glRotatef((float)(angleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(angleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        int rings = MathHelper.func_76123_f((float)(length * 4.0f / 16.0f)) + 1;
        for (int i = 0; i < rings; ++i) {
            float t = (float)i / (float)rings * length / 16.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)t);
            float rotZ = ModelConnectionGarland.rand(index + i + this.uniquifier) * 45.0f;
            float rotY = ModelConnectionGarland.rand(index + i + 8 + this.uniquifier) * 60.0f + 90.0f;
            GL11.glPushMatrix();
            GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.25f, (float)-0.25f, (float)-0.03125f);
            int ring = this.ringId + index % 8;
            GL11.glCallList((int)ring);
            GL11.glPopMatrix();
            GL11.glRotatef((float)(rotZ + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.875f, (float)0.875f, (float)0.875f);
            GL11.glTranslatef((float)-0.25f, (float)-0.25f, (float)-0.03125f);
            GL11.glCallList((int)ring);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private static float rand(int index) {
        return RANDOM_VALUES[MathUtils.modi(index, RANDOM_VALUES.length)];
    }

    static {
        Random random = new Random(8411L);
        for (int i = 0; i < RANDOM_VALUES.length; ++i) {
            ModelConnectionGarland.RANDOM_VALUES[i] = random.nextFloat() * 2.0f - 1.0f;
        }
    }
}

