/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.lights;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.RotationOrder;
import com.pau101.fairylights.client.model.lights.ModelLight;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.util.MathUtils;
import com.pau101.fairylights.util.vectormath.Vector3f;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ModelLightFlower
extends ModelLight {
    private AdvancedModelRenderer[] peddles;
    private static final float PEDDLE_ANGLE = -0.5235988f;
    private static final float[] MAGIC_ANGLES = MathUtils.toEuler(-1.0f, 0.0f, 1.0f, -0.5235988f);

    public ModelLightFlower() {
        this.amutachromicParts.setTextureOffset(12, 0);
        this.amutachromicParts.addBox(-1.5f, 0.0f, -1.5f, 3, 2, 3);
        int peddleCount = 5;
        this.peddles = new AdvancedModelRenderer[peddleCount];
        for (int p = 0; p < peddleCount; ++p) {
            float theta = (float)p / (float)peddleCount * ((float)Math.PI * 2);
            float x = MathHelper.func_76134_b((float)theta);
            float z = MathHelper.func_76126_a((float)theta);
            AdvancedModelRenderer peddleModel = new AdvancedModelRenderer(this, 24, 0);
            peddleModel.setRotationOrder(RotationOrder.YZX);
            peddleModel.addBox(0.0f, 0.0f, 0.0f, 5, 1, 5);
            peddleModel.field_78797_d = 1.0f;
            peddleModel.field_78795_f = MAGIC_ANGLES[0];
            peddleModel.field_78796_g = MAGIC_ANGLES[1] + theta;
            peddleModel.field_78808_h = MAGIC_ANGLES[2];
            this.colorableParts.addChild(peddleModel);
            this.peddles[p] = peddleModel;
        }
    }

    @Override
    public boolean hasRandomRotatation() {
        return true;
    }

    @Override
    public void render(World world, Light light, float scale, Vector3f color, int moonlight, int sunlight, float brightness, int index, float partialRenderTicks) {
        float randomTilt = MathUtils.modf((float)MathUtils.hash(index) * ((float)Math.PI / 180), (float)Math.PI * 2) / ((float)Math.PI * 2) * (float)Math.PI / 8.0f - 0.19634955f;
        this.colorableParts.field_78808_h += randomTilt;
        this.amutachromicParts.field_78808_h += randomTilt;
        super.render(world, light, scale, color, moonlight, sunlight, brightness, index, partialRenderTicks);
    }
}

