/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.lights;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.lights.ModelLight;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.util.MathUtils;
import com.pau101.fairylights.util.vectormath.Vector3f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ModelLightMeteor
extends ModelLight {
    private AdvancedModelRenderer[] lights;
    private AdvancedModelRenderer connector = new AdvancedModelRenderer(this, 77, 0);
    private AdvancedModelRenderer cap;
    private AdvancedModelRenderer rodDepthMask;

    public ModelLightMeteor() {
        this.connector.func_78790_a(-1.0f, -0.5f, -1.0f, 2, 2, 2, 0.0f);
        this.amutachromicParts.addChild(this.connector);
        this.cap = new AdvancedModelRenderer(this, 77, 0);
        this.cap.func_78790_a(-1.0f, -25.400002f, -1.0f, 2, 1, 2, 0.0f);
        this.amutachromicParts.addChild(this.cap);
        int lightCount = 12;
        this.lights = new AdvancedModelRenderer[lightCount];
        float rodScale = 0.8f;
        for (int i = 0; i < lightCount; ++i) {
            AdvancedModelRenderer light = new AdvancedModelRenderer(this, 37, 72);
            light.addMeteorLightBox(-1.0f, (float)(-i * 2) - 2.5f + 0.05f, -1.0f, 2, 2, 2, i == 0 ? 0 : (i == lightCount - 1 ? 1 : 2));
            light.isMeteorLightGlow = true;
            this.lights[i] = light;
            light.scaleX = light.scaleZ = rodScale;
            this.colorableParts.addChild(light);
        }
        this.rodDepthMask = new AdvancedModelRenderer(this);
        this.rodDepthMask.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 24, 2, 0.45f);
        this.rodDepthMask.field_78795_f = (float)Math.PI;
        this.rodDepthMask.scaleX = this.rodDepthMask.scaleZ = rodScale;
        this.amutachromicParts.addChild(this.rodDepthMask);
    }

    @Override
    public boolean hasRandomRotatation() {
        return true;
    }

    @Override
    public boolean shouldParallelCord() {
        return false;
    }

    @Override
    public void render(World world, Light light, float scale, Vector3f color, int moonlight, int sunlight, float normalBrightness, int index, float delta) {
        float[] hsb;
        float brightness;
        float t;
        int i;
        if (this.hasRandomRotatation()) {
            float randomOffset;
            this.colorableParts.secondaryRotateAngleY = randomOffset = MathUtils.modf((float)MathUtils.hash(index) * ((float)Math.PI / 180), (float)Math.PI * 2) + 0.7853982f;
            this.amutachromicParts.secondaryRotateAngleY = randomOffset;
        }
        float stage = light.getTwinkleTimePercent(delta) * 3.0f - 1.0f;
        this.rodDepthMask.field_78807_k = true;
        for (i = 0; i < this.lights.length; ++i) {
            t = (float)i / (float)this.lights.length;
            float f = brightness = t - stage > 0.0f ? 1.0f - Math.abs(t - stage) * 4.0f : 1.0f - Math.abs(t - stage);
            if (brightness < 0.0f) {
                brightness = 0.0f;
            }
            if (brightness > 1.0f) {
                brightness = 1.0f;
            }
            hsb = new float[3];
            Color.RGBtoHSB((int)(color.x * 255.0f + 0.5f), (int)(color.y * 255.0f + 0.5f), (int)(color.z * 255.0f + 0.5f), hsb);
            hsb[2] = brightness * 0.75f + 0.25f;
            int colorRGB = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            float cr = (float)(colorRGB >> 16 & 0xFF) / 255.0f;
            float cg = (float)(colorRGB >> 8 & 0xFF) / 255.0f;
            float cb = (float)(colorRGB & 0xFF) / 255.0f;
            GL11.glColor3f((float)cr, (float)cg, (float)cb);
            float b = Math.max(Math.max(brightness, world.func_72971_b(1.0f) * 0.95f + 0.05f) * 240.0f, (float)sunlight);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)b, (float)moonlight);
            GL11.glEnable((int)2896);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].field_78807_k = i != n;
            }
            this.colorableParts.func_78785_a(scale);
            if (i != 0 && i != this.lights.length - 1) continue;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)sunlight, (float)moonlight);
            float c = b / 255.0f;
            if (c < 0.5f) {
                c = 0.5f;
            }
            GL11.glColor3f((float)c, (float)c, (float)c);
            this.connector.field_78807_k = i != 0;
            this.cap.field_78807_k = i == 0;
            this.amutachromicParts.func_78785_a(scale);
            GL11.glDisable((int)2896);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)sunlight, (float)moonlight);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().field_71460_t.func_78483_a((double)delta);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        this.colorableParts.isGlowing = true;
        GL11.glDepthMask((boolean)false);
        for (i = 0; i < this.lights.length; ++i) {
            t = (float)i / (float)this.lights.length;
            float f = brightness = t - stage > 0.0f ? 1.0f - Math.abs(t - stage) * 4.0f : 1.0f - Math.abs(t - stage) * 2.0f;
            if (brightness < 0.0f) {
                brightness = 0.0f;
            }
            if (brightness > 1.0f) {
                brightness = 1.0f;
            }
            hsb = new float[3];
            Color.RGBtoHSB((int)(color.x * 255.0f + 0.5f), (int)(color.y * 255.0f + 0.5f), (int)(color.z * 255.0f + 0.5f), hsb);
            hsb[2] = brightness * 0.75f + 0.25f;
            boolean maxBrightness = true;
            float expand = 1.3f;
            Color.RGBtoHSB((int)(color.x * 255.0f + 0.5f), (int)(color.y * 255.0f + 0.5f), (int)(color.z * 255.0f + 0.5f), hsb);
            if (hsb[1] > 0.0f) {
                hsb[1] = brightness;
                hsb[2] = 1.0f;
            }
            int colorRGB = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            float cr = (float)(colorRGB >> 16 & 0xFF) / 255.0f;
            float cg = (float)(colorRGB >> 8 & 0xFF) / 255.0f;
            float cb = (float)(colorRGB & 0xFF) / 255.0f;
            cr = (float)(colorRGB >> 16 & 0xFF) / 255.0f;
            cg = (float)(colorRGB >> 8 & 0xFF) / 255.0f;
            cb = (float)(colorRGB & 0xFF) / 255.0f;
            GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)(brightness * 0.15f + 0.1f));
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].field_78807_k = i != n;
            }
            this.colorableParts.func_78785_a(scale);
        }
        GL11.glDepthMask((boolean)true);
        this.colorableParts.isGlowing = false;
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Minecraft.func_71410_x().field_71460_t.func_78463_b((double)delta);
        GL11.glDisable((int)3008);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.rodDepthMask.field_78807_k = false;
        this.connector.field_78807_k = true;
        this.cap.field_78807_k = true;
        this.amutachromicParts.func_78785_a(scale);
        this.connector.field_78807_k = false;
        this.cap.field_78807_k = false;
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)3008);
    }
}

