/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.renderer;

import com.pau101.fairylights.block.BlockConnectionFastener;
import com.pau101.fairylights.block.BlockConnectionFastenerFence;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.connection.ConnectionLogicGarland;
import com.pau101.fairylights.connection.ConnectionType;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.mc.EnumFacing;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class ConnectionRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("fairylights", "textures/entity/fairy_lights.png");
    public static final int TEXTURE_WIDTH = 128;
    public static final int TEXTURE_HEIGHT = 128;
    private Field currentFrustumField = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"currentFrustum"});
    private ModelConnection[] connectionRenderers;

    public ConnectionRenderer() {
        ConnectionType[] types = ConnectionType.values();
        this.connectionRenderers = new ModelConnection[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.connectionRenderers[i] = types[i].createRenderer();
        }
    }

    private Frustrum getFrustrum() {
        try {
            return (Frustrum)this.currentFrustumField.get(Minecraft.func_71410_x().field_71460_t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        float delta = e.partialTicks;
        WorldClient world = mc.field_71441_e;
        Frustrum frustrum = this.getFrustrum();
        mc.func_110434_K().func_110577_a(TEXTURE);
        mc.field_71460_t.func_78463_b((double)delta);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2912);
        for (TileEntity loadedTileEntity : world.field_147482_g) {
            TileEntityConnectionFastener fastener;
            if (!(loadedTileEntity instanceof TileEntityConnectionFastener) || !frustrum.func_78546_a((fastener = (TileEntityConnectionFastener)loadedTileEntity).getRenderBoundingBox())) continue;
            int x = fastener.field_145851_c;
            int y = fastener.field_145848_d;
            int z = fastener.field_145849_e;
            int combinedLight = world.func_72802_i(x, y, z, 0);
            int sunlight = combinedLight % 65536;
            int moonlight = combinedLight / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)sunlight, (float)moonlight);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)x - TileEntityRendererDispatcher.field_147554_b), (double)((double)y - TileEntityRendererDispatcher.field_147555_c), (double)((double)z - TileEntityRendererDispatcher.field_147552_d));
            this.renderConnections(fastener, delta);
            GL11.glPopMatrix();
            if (!RenderManager.field_85095_o) continue;
            this.drawBoundingBox(fastener);
        }
        GL11.glDisable((int)2912);
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_78483_a((double)delta);
    }

    private void drawBoundingBox(TileEntityConnectionFastener fastener) {
        RenderHelper.func_74518_a();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        RenderGlobal.func_147590_a((AxisAlignedBB)fastener.getRenderBoundingBox(), (int)0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        RenderHelper.func_74519_b();
    }

    public void renderConnections(TileEntityConnectionFastener fastener, float delta) {
        World world = fastener.func_145831_w();
        if (world == null || !(world.func_147439_a(fastener.field_145851_c, fastener.field_145848_d, fastener.field_145849_e) instanceof BlockConnectionFastener)) {
            return;
        }
        List<Connection> connections = ConnectionRenderer.removeUnnecessaryConnections(fastener.getConnections());
        GL11.glPushMatrix();
        Point3f offset = ((BlockConnectionFastener)fastener.func_145838_q()).getOffsetForData(fastener.func_145831_w().func_72805_g(fastener.field_145851_c, fastener.field_145848_d, fastener.field_145849_e), 0.125f);
        GL11.glTranslatef((float)offset.x, (float)offset.y, (float)offset.z);
        int blockBrightness = fastener.func_145831_w().func_72802_i(fastener.field_145851_c, fastener.field_145848_d, fastener.field_145849_e, 0);
        int skylight = blockBrightness % 65536;
        int moonlight = blockBrightness / 65536;
        GL11.glEnable((int)32826);
        boolean shouldRenderBow = true;
        for (Connection connection : connections) {
            if (connection.isOrigin()) {
                ModelConnection renderer = this.connectionRenderers[connection.getType().ordinal()];
                renderer.render(fastener, connection.getLogic(), world, skylight, moonlight, delta);
            }
            if (!(connection.getLogic() instanceof ConnectionLogicGarland) || !shouldRenderBow) continue;
            this.renderBow(fastener, connections, delta);
            shouldRenderBow = false;
        }
        GL11.glEnable((int)32826);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderBow(TileEntityConnectionFastener fastener, Collection<Connection> connections, float delta) {
        if (fastener.func_145838_q() instanceof BlockConnectionFastenerFence) {
            return;
        }
        EnumFacing facing = BlockConnectionFastener.DATA_TO_FACING[fastener.func_145832_p()];
        if (facing.getAxis() == EnumFacing.Axis.Y) {
            return;
        }
        Vector3f fastenerDir = new Vector3f(facing.getDirectionVec());
        float yaw = (float)(-Math.atan2(fastenerDir.z, fastenerDir.x)) - 1.5707964f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(fastenerDir.x * 1.5f / 16.0f), (float)0.0f, (float)(fastenerDir.z * 1.5f / 16.0f));
        GL11.glRotatef((float)(yaw * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5625f, (float)-0.375f, (float)-0.03125f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)2.5f);
        ConnectionRenderer.render3DTexture(18, 12, 0, 72);
        GL11.glPopMatrix();
    }

    private static List<Connection> removeUnnecessaryConnections(Collection<Connection> connections) {
        ArrayList<Connection> visibleConnections = new ArrayList<Connection>();
        for (Connection connection : connections) {
            Segment[] vertices;
            Catenary catenary = connection.getCatenary();
            if (catenary == null || connection.getTo() == null || (vertices = catenary.getSegments()) == null) continue;
            visibleConnections.add(connection);
        }
        return visibleConnections;
    }

    public static void render3DTexture(int width, int height, int u, int v) {
        float vi;
        float ui;
        int p;
        float u1 = (float)u / 128.0f;
        float u2 = (float)(u + width) / 128.0f;
        float v1 = (float)v / 128.0f;
        float v2 = (float)(v + height) / 128.0f;
        GL11.glPushMatrix();
        GL11.glScalef((float)((float)width / 16.0f), (float)((float)height / 16.0f), (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        float depth = 0.0625f;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)u1, (double)v2);
        tessellator.func_78374_a(1.0, 0.0, 0.0, (double)u2, (double)v2);
        tessellator.func_78374_a(1.0, 1.0, 0.0, (double)u2, (double)v1);
        tessellator.func_78374_a(0.0, 1.0, 0.0, (double)u1, (double)v1);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(0.0, 1.0, (double)(-depth), (double)u1, (double)v1);
        tessellator.func_78374_a(1.0, 1.0, (double)(-depth), (double)u2, (double)v1);
        tessellator.func_78374_a(1.0, 0.0, (double)(-depth), (double)u2, (double)v2);
        tessellator.func_78374_a(0.0, 0.0, (double)(-depth), (double)u1, (double)v2);
        tessellator.func_78381_a();
        float widthStretch = 0.5f * (u1 - u2) / (float)width;
        float heightStretch = 0.5f * (v2 - v1) / (float)height;
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (p = 0; p < width; ++p) {
            float x = (float)p / (float)width;
            ui = u1 + (u2 - u1) * x - widthStretch;
            tessellator.func_78374_a((double)x, 0.0, (double)(-depth), (double)ui, (double)v2);
            tessellator.func_78374_a((double)x, 0.0, 0.0, (double)ui, (double)v2);
            tessellator.func_78374_a((double)x, 1.0, 0.0, (double)ui, (double)v1);
            tessellator.func_78374_a((double)x, 1.0, (double)(-depth), (double)ui, (double)v1);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        for (p = 0; p < width; ++p) {
            float xi = (float)p / (float)width;
            ui = u1 + (u2 - u1) * xi - widthStretch;
            float x = xi + 1.0f / (float)width;
            tessellator.func_78374_a((double)x, 1.0, (double)(-depth), (double)ui, (double)v1);
            tessellator.func_78374_a((double)x, 1.0, 0.0, (double)ui, (double)v1);
            tessellator.func_78374_a((double)x, 0.0, 0.0, (double)ui, (double)v2);
            tessellator.func_78374_a((double)x, 0.0, (double)(-depth), (double)ui, (double)v2);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        for (p = 0; p < height; ++p) {
            float yi = (float)p / (float)height;
            vi = v2 + (v1 - v2) * yi - heightStretch;
            float y = yi + 1.0f / (float)height;
            tessellator.func_78374_a(0.0, (double)y, 0.0, (double)u1, (double)vi);
            tessellator.func_78374_a(1.0, (double)y, 0.0, (double)u2, (double)vi);
            tessellator.func_78374_a(1.0, (double)y, (double)(-depth), (double)u2, (double)vi);
            tessellator.func_78374_a(0.0, (double)y, (double)(-depth), (double)u1, (double)vi);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        for (p = 0; p < height; ++p) {
            float y = (float)p / (float)height;
            vi = v2 + (v1 - v2) * y - heightStretch;
            tessellator.func_78374_a(1.0, (double)y, 0.0, (double)u2, (double)vi);
            tessellator.func_78374_a(0.0, (double)y, 0.0, (double)u1, (double)vi);
            tessellator.func_78374_a(0.0, (double)y, (double)(-depth), (double)u1, (double)vi);
            tessellator.func_78374_a(1.0, (double)y, (double)(-depth), (double)u2, (double)vi);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }
}

