/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.connection;

import com.pau101.fairylights.connection.ConnectionLogic;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.connection.PatternLightData;
import com.pau101.fairylights.eggs.Jingle;
import com.pau101.fairylights.eggs.JinglePlayer;
import com.pau101.fairylights.item.LightVariant;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.mc.EnumDyeColor;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ConnectionLogicFairyLights
extends ConnectionLogic {
    private Light[] lightPoints;
    private Light[] prevLightPoints;
    private List<PatternLightData> pattern = new ArrayList<PatternLightData>();
    private boolean twinkle;
    private boolean tight;
    public JinglePlayer jinglePlayer = new JinglePlayer();

    public ConnectionLogicFairyLights(Connection connection) {
        super(connection);
    }

    public Light[] getLightPoints() {
        return this.lightPoints;
    }

    public Light[] getPrevLightPoints() {
        return this.prevLightPoints;
    }

    public List<PatternLightData> getPattern() {
        return this.pattern;
    }

    public boolean isTight() {
        return this.tight;
    }

    public void play(Jingle jingle, int lightOffset) {
        if (!this.jinglePlayer.isPlaying()) {
            this.jinglePlayer.play(jingle, lightOffset);
        }
    }

    public void setPatern(List<PatternLightData> pattern) {
        this.pattern = pattern;
    }

    @Override
    public void onUpdate() {
        this.prevLightPoints = this.lightPoints;
    }

    @Override
    public void onUpdateEnd() {
        this.updateLights();
    }

    @Override
    public void onRecalculateCatenary() {
        this.updateLightVertices();
    }

    @Override
    public Catenary createCatenary(Point3f to) {
        return Catenary.from(new Vector3f(to), this.tight);
    }

    public void updateLights() {
        if (this.lightPoints != null) {
            for (int i = 0; i < this.lightPoints.length; ++i) {
                Light light = this.lightPoints[i];
                if (this.pattern.size() > 0) {
                    PatternLightData lightData = this.pattern.get(i % this.pattern.size());
                    light.setVariant(lightData.getLightVariant());
                    light.setColor(EnumDyeColor.byDyeDamage((int)lightData.getColor()).getMapColor().field_76291_p);
                }
                light.tick(this, this.twinkle);
                if (!this.jinglePlayer.isPlaying() || !this.getConnection().getWorldObj().field_72995_K) continue;
                this.jinglePlayer.play(i, this.getConnection().getFastener().getConnectionPoint(), light);
            }
            if (this.jinglePlayer.isPlaying()) {
                this.jinglePlayer.tick();
            }
        }
    }

    private void updateLightVertices() {
        Catenary catenary = this.getConnection().getCatenary();
        if (catenary != null) {
            float spacing = 16.0f;
            for (PatternLightData patternLightData : this.pattern) {
                float lightSpacing = patternLightData.getLightVariant().getSpacing();
                if (!(lightSpacing > spacing)) continue;
                spacing = lightSpacing;
            }
            float totalLength = catenary.getLength();
            float distance = (totalLength % spacing + spacing) / 2.0f;
            Segment[] segments = catenary.getSegments();
            this.prevLightPoints = this.lightPoints;
            this.lightPoints = new Light[(int)(totalLength / spacing)];
            int lightIndex = 0;
            for (int i = 0; i < segments.length; ++i) {
                Segment segment = segments[i];
                float length = segment.getLength();
                while (distance < length) {
                    Light light = new Light(segment.pointAt(distance / length));
                    if (this.prevLightPoints != null && lightIndex < this.prevLightPoints.length) {
                        light.setTwinkleTime(this.prevLightPoints[lightIndex].getTwinkleTime());
                    }
                    light.setRotation(segment.getRotation());
                    this.lightPoints[lightIndex++] = light;
                    distance += spacing;
                }
                distance -= length;
            }
        }
    }

    public boolean canCurrentlyPlayAJingle() {
        return !this.jinglePlayer.isPlaying();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (PatternLightData b : this.pattern) {
            NBTTagCompound patternCompound = new NBTTagCompound();
            patternCompound.func_74768_a("light", b.getLightVariant().ordinal());
            patternCompound.func_74774_a("color", b.getColor());
            tagList.func_74742_a((NBTBase)patternCompound);
        }
        compound.func_74782_a("pattern", (NBTBase)tagList);
        compound.func_74757_a("twinkle", this.twinkle);
        compound.func_74757_a("tight", this.tight);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList tagList = compound.func_150295_c("pattern", 10);
        this.pattern = new ArrayList<PatternLightData>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound lightCompound = tagList.func_150305_b(i);
            LightVariant lightVariant = LightVariant.getLightVariant(lightCompound.func_74762_e("light"));
            byte color = lightCompound.func_74771_c("color");
            this.pattern.add(new PatternLightData(lightVariant, color));
        }
        this.twinkle = compound.func_74767_n("twinkle");
        this.tight = compound.func_74767_n("tight");
    }
}

