/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.connection;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.client.model.connection.ModelConnectionFairyLights;
import com.pau101.fairylights.client.model.connection.ModelConnectionGarland;
import com.pau101.fairylights.client.model.connection.ModelConnectionTinsel;
import com.pau101.fairylights.connection.ConnectionLogic;
import com.pau101.fairylights.connection.ConnectionLogicFairyLights;
import com.pau101.fairylights.connection.ConnectionLogicGarland;
import com.pau101.fairylights.connection.ConnectionLogicTinsel;
import com.pau101.fairylights.item.ItemConnection;
import com.pau101.fairylights.tileentity.connection.Connection;
import net.minecraft.util.MathHelper;

public enum ConnectionType {
    FAIRY_LIGHTS{

        @Override
        public ConnectionLogic createLogic(Connection connection) {
            return new ConnectionLogicFairyLights(connection);
        }

        @Override
        public ItemConnection getItem() {
            return FairyLights.fairyLights;
        }

        @Override
        public ModelConnection createRenderer() {
            return new ModelConnectionFairyLights();
        }

        @Override
        public boolean isConnectionThis(Connection connection) {
            return connection.getLogic() instanceof ConnectionLogicFairyLights;
        }
    }
    ,
    GARLAND{

        @Override
        public ConnectionLogic createLogic(Connection connection) {
            return new ConnectionLogicGarland(connection);
        }

        @Override
        public ItemConnection getItem() {
            return FairyLights.garland;
        }

        @Override
        public ModelConnection createRenderer() {
            return new ModelConnectionGarland();
        }

        @Override
        public boolean isConnectionThis(Connection connection) {
            return connection.getLogic() instanceof ConnectionLogicGarland;
        }
    }
    ,
    TINSEL{

        @Override
        public ConnectionLogic createLogic(Connection connection) {
            return new ConnectionLogicTinsel(connection);
        }

        @Override
        public ItemConnection getItem() {
            return FairyLights.tinsel;
        }

        @Override
        public ModelConnection createRenderer() {
            return new ModelConnectionTinsel();
        }

        @Override
        public boolean isConnectionThis(Connection connection) {
            return connection.getLogic() instanceof ConnectionLogicTinsel;
        }
    };


    public abstract ConnectionLogic createLogic(Connection var1);

    public abstract ItemConnection getItem();

    public abstract ModelConnection createRenderer();

    public abstract boolean isConnectionThis(Connection var1);

    public static ConnectionType from(int ordinal) {
        ConnectionType[] values = ConnectionType.values();
        return values[MathHelper.func_76125_a((int)ordinal, (int)0, (int)(values.length - 1))];
    }
}

