/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.connection;

import com.pau101.fairylights.connection.ConnectionLogicFairyLights;
import com.pau101.fairylights.item.LightVariant;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.util.CubicBezier;
import com.pau101.fairylights.util.MathUtils;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;

public class Light {
    private static final CubicBezier EASE_IN_OUT = new CubicBezier(0.4f, 0.0f, 0.6f, 1.0f);
    private static final int NORMAL_LIGHT = -1;
    private Point3f point;
    private Vector3f rotation;
    private LightVariant variant;
    private Vector3f color;
    private int prevTwinkleTime;
    private int twinkleTime;
    private boolean isTwinkling;
    private int sway;
    private boolean swaying;
    private boolean swayDirection;
    private int swayRate = 10;
    private int swayPeakCount = 5;
    private int swayCycle = this.swayRate * this.swayPeakCount;

    public Light(Point3f point) {
        this.point = point;
        this.rotation = new Vector3f();
        this.color = new Vector3f(1.0f, 0.91764706f, 0.75686276f);
        this.twinkleTime = -1;
        this.sway = 0;
        this.swaying = false;
    }

    public Point3f getAbsolutePoint(TileEntityConnectionFastener fastener) {
        Point3f point = this.getPoint();
        point.scale(0.0625f);
        point.add(fastener.getConnectionPoint());
        return point;
    }

    public boolean isTwinkling() {
        return this.isTwinkling;
    }

    public float getBrightness(float delta) {
        return this.twinkleTime == -1 ? (this.isTwinkling ? 0.0f : 1.0f) : this.brightnessFunc(((float)this.prevTwinkleTime + (float)(this.twinkleTime - this.prevTwinkleTime) * delta) / (float)this.getVariant().getTickCycle());
    }

    public float getTwinkleTimePercent(float delta) {
        return this.twinkleTime == -1 ? 0.0f : ((float)this.prevTwinkleTime + (float)(this.twinkleTime - this.prevTwinkleTime) * delta) / (float)this.getVariant().getTickCycle();
    }

    private float brightnessFunc(float x) {
        return x < 0.25f ? EASE_IN_OUT.eval(x / 0.25f) : 1.0f - EASE_IN_OUT.eval(MathUtils.linearTransformf(x, 0.25f, 1.0f, 0.0f, 1.0f));
    }

    public LightVariant getVariant() {
        return this.variant == null ? LightVariant.FAIRY : this.variant;
    }

    public Vector3f getLight() {
        return this.color;
    }

    public Point3f getPoint() {
        return new Point3f(this.point);
    }

    public Vector3f getRotation() {
        return new Vector3f(this.rotation);
    }

    public void setVariant(LightVariant variant) {
        this.variant = variant;
    }

    public void setColor(int colorValue) {
        this.color = new Vector3f((float)(colorValue >> 16 & 0xFF) / 255.0f, (float)(colorValue >> 8 & 0xFF) / 255.0f, (float)(colorValue & 0xFF) / 255.0f);
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setTwinkleTime(int twinkleTime) {
        this.twinkleTime = twinkleTime;
    }

    public int getTwinkleTime() {
        return this.twinkleTime;
    }

    public void startSwaying() {
        this.swayDirection = Math.random() < 0.5;
        this.swaying = true;
        this.sway = 0;
    }

    public void stopSwaying() {
        this.sway = 0;
        this.rotation.z = 0.0f;
        this.swaying = false;
    }

    public void tick(ConnectionLogicFairyLights connectionLogic, boolean twinkle) {
        this.prevTwinkleTime = this.twinkleTime;
        this.isTwinkling = twinkle;
        if (this.isTwinkling || this.getVariant().alwaysDoTwinkleLogic()) {
            if (connectionLogic.getConnection().getWorldObj().field_73012_v.nextFloat() < this.getVariant().getTwinkleChance() && this.twinkleTime == -1) {
                this.twinkleTime = 0;
            }
            if (this.twinkleTime >= 0) {
                ++this.twinkleTime;
            }
            if (this.twinkleTime == this.getVariant().getTickCycle()) {
                this.twinkleTime = -1;
            }
        }
        if (this.swaying) {
            if (this.sway == this.swayCycle) {
                this.stopSwaying();
            }
            this.rotation.z = (float)(Math.sin((double)((this.swayDirection ? 1 : -1) * 2) * Math.PI / (double)this.swayRate * (double)this.sway) * Math.pow(114.59155902616465, (float)(-this.sway++) / (float)this.swayCycle));
        }
    }
}

