/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.core;

import java.util.List;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FairyLightsClassTransformer
implements IClassTransformer {
    private Logger logger = Logger.getLogger("FairyLightsClassTransformer");
    private String fieldNameAddition = "currentFrustum";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean obf = false;
        obf = "bll".equals(name);
        if (obf || "net.minecraft.client.renderer.EntityRenderer".equals(name)) {
            String frustumDesc;
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            String entityRendererOwner = obf ? "bll" : "net/minecraft/client/renderer/EntityRenderer";
            String string = frustumDesc = obf ? "Lbmp;" : "Lnet/minecraft/client/renderer/culling/Frustrum;";
            if (!this.transformFrustumStore(obf, classNode.methods, entityRendererOwner, frustumDesc)) {
                this.logger.severe("Failed to transform the EntityRenderer!");
                return basicClass;
            }
            classNode.fields.add(new FieldNode(1, this.fieldNameAddition, frustumDesc, null, null));
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private boolean transformFrustumStore(boolean obf, List<MethodNode> methods, String entityRendererOwner, String frustumDesc) {
        boolean replacedASTORE8 = false;
        for (MethodNode method : methods) {
            if (!"(FJ)V".equals(method.desc)) continue;
            InsnList instructions = method.instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                AbstractInsnNode instruction = instructions.get(i);
                if (replacedASTORE8) {
                    if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 14) continue;
                    ((VarInsnNode)instruction).var = 0;
                    instructions.insert(instruction, (AbstractInsnNode)new FieldInsnNode(180, entityRendererOwner, this.fieldNameAddition, frustumDesc));
                    continue;
                }
                if (instruction.getOpcode() != 58 || ((VarInsnNode)instruction).var != 14) continue;
                InsnList newInsn = new InsnList();
                instructions.insertBefore(instructions.get(i - 3), (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.set(instruction, (AbstractInsnNode)new FieldInsnNode(181, entityRendererOwner, this.fieldNameAddition, frustumDesc));
                replacedASTORE8 = true;
            }
        }
        return replacedASTORE8;
    }
}

