/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.eggs;

import com.pau101.fairylights.config.Configurator;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.eggs.Jingle;
import com.pau101.fairylights.util.vectormath.Point3f;
import java.util.List;
import net.minecraft.client.Minecraft;

public class JinglePlayer {
    private Jingle jingle;
    private List<Jingle.PlayTick> jinglePlayTicks;
    private int lightOffset;
    private int tick = -1;
    private int jingleLength;
    private static final String SOUND_FX = "fairylights:jinglebell";
    private static final int NOT_PLAYING = -1;

    public void play(Jingle jingle, int lightOffset) {
        this.jingle = jingle;
        this.jinglePlayTicks = jingle.getPlayTicks();
        this.lightOffset = lightOffset;
        this.tick = 0;
        this.jingleLength = 0;
        for (Jingle.PlayTick playTick : this.jinglePlayTicks) {
            this.jingleLength += playTick.getLength();
        }
    }

    public boolean isPlaying() {
        return this.tick != -1;
    }

    public void play(int index, Point3f coordinateOffset, Light light) {
        Minecraft mc = Minecraft.func_71410_x();
        int played = 0;
        for (Jingle.PlayTick playTick : this.jinglePlayTicks) {
            if (played == this.tick) {
                for (int note : playTick.getNotes()) {
                    if (note != index + this.jingle.getLowestNote() - this.lightOffset) continue;
                    Point3f lightPoint = light.getPoint();
                    double x = coordinateOffset.x + lightPoint.x / 16.0f;
                    double y = coordinateOffset.y + lightPoint.y / 16.0f;
                    double z = coordinateOffset.z + lightPoint.z / 16.0f;
                    mc.field_71441_e.func_72980_b(x, y, z, SOUND_FX, (float)Configurator.jingleAmplitude / 16.0f, (float)Math.pow(2.0, (float)(note - 12) / 12.0f), false);
                    light.startSwaying();
                    break;
                }
                return;
            }
            if (played > this.tick) {
                return;
            }
            played += playTick.getLength();
        }
    }

    public void setLightOffset(int lightOffset) {
        this.lightOffset = lightOffset;
    }

    public void tick() {
        ++this.tick;
        if (this.tick >= this.jingleLength) {
            this.tick = -1;
        }
    }
}

