/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.item;

import com.pau101.fairylights.FairyLights;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum LightVariant {
    FAIRY("fairy", new Object[]{" I ", "IDI", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('G'), "paneGlassColorless"}),
    PAPER("paper", new Object[]{" I ", "PDP", "PPP", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('P'), Items.field_151121_aF}),
    ORB("orb", new Object[]{" I ", "SDS", " W ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('W'), Blocks.field_150325_L}),
    FLOWER("flower", new Object[]{" I ", "RDB", " Y ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('R'), new ItemStack((Block)Blocks.field_150328_O, 1, 0), Character.valueOf('Y'), new ItemStack((Block)Blocks.field_150327_N, 1, 0), Character.valueOf('B'), new ItemStack((Block)Blocks.field_150328_O, 1, 1)}),
    ORNATE("ornate", 24.0f, new Object[]{" I ", "GDG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('G'), "nuggetGold"}),
    OIL("oil", 32.0f, new Object[]{" I ", "SDS", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('S'), "stickWood", Character.valueOf('G'), "paneGlassColorless"}),
    LUXO_BALL("luxo_ball", new Object[]{" I ", "BBB", "YRY", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "dyeBlue", Character.valueOf('Y'), "dyeYellow", Character.valueOf('R'), "dyeRed"}),
    JACK_O_LANTERN("jack_o_lantern", new Object[]{" I ", "SDS", "GPG", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150376_bx, 1, 4), Character.valueOf('G'), Blocks.field_150478_aa, Character.valueOf('P'), Blocks.field_150423_aK}),
    SKULL("skull", new Object[]{" I ", "IDI", " B ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('B'), Items.field_151103_aS}),
    GHOST("ghost", new Object[]{" I ", "PDP", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('G'), "paneGlassWhite"}),
    SPIDER("spider", new Object[]{" I ", "WDW", "SES", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('W'), Blocks.field_150321_G, Character.valueOf('S'), Items.field_151007_F, Character.valueOf('E'), Items.field_151070_bp}),
    WITCH("witch", new Object[]{" I ", "BDW", " S ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('B'), Items.field_151069_bo, Character.valueOf('W'), Items.field_151015_O, Character.valueOf('S'), "stickWood"}),
    WEEDWOOD_LANTERN("weedwood_lantern", 32.0f, new Object[]{" I ", "SDS", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150376_bx, 1, 5), Character.valueOf('G'), "stickWood"}),
    SNOWFLAKE("snowflake", new Object[]{" I ", "SDS", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), Items.field_151126_ay, Character.valueOf('D'), "dye", Character.valueOf('G'), "paneGlassWhite"}),
    ICICLE("icicle", new Object[]{" I ", "GDG", " B ", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "paneGlassColorless", Character.valueOf('D'), "dye", Character.valueOf('B'), Items.field_151131_as}),
    METEOR("meteor", 24.0f, new Object[]{" I ", "GDG", "IPI", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "dye", Character.valueOf('G'), Items.field_151114_aO, Character.valueOf('P'), Items.field_151121_aF}, 0.02f, 100){

        @Override
        public boolean alwaysDoTwinkleLogic() {
            return true;
        }
    };

    private String name;
    private float spacing;
    private ItemStack craftingResult;
    private Object[] craftingRecipe;
    private float twinkleChance;
    private int tickCycle;

    private LightVariant(String name, Object[] craftingRecipe) {
        this(name, 16.0f, craftingRecipe);
    }

    private LightVariant(String name, float spacing, Object[] craftingRecipe) {
        this(name, spacing, craftingRecipe, 0.05f, 40);
    }

    private LightVariant(String name, float spacing, Object[] craftingRecipe, float twinkleChance, int tickCycle) {
        this.name = name;
        this.spacing = spacing;
        this.craftingRecipe = craftingRecipe;
        this.twinkleChance = twinkleChance;
        this.tickCycle = tickCycle;
    }

    public String getName() {
        return this.name;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public ItemStack getCraftingResult() {
        return this.craftingResult;
    }

    public Object[] getCraftingRecipe() {
        return this.craftingRecipe;
    }

    public float getTwinkleChance() {
        return this.twinkleChance;
    }

    public int getTickCycle() {
        return this.tickCycle;
    }

    public boolean alwaysDoTwinkleLogic() {
        return false;
    }

    public static LightVariant getLightVariant(int index) {
        LightVariant[] variants = LightVariant.values();
        return variants[index < 0 || index >= variants.length ? 0 : index];
    }

    static {
        LightVariant[] variants = LightVariant.values();
        for (int meta = 0; meta < variants.length; ++meta) {
            variants[meta].craftingResult = new ItemStack((Item)FairyLights.light, 4, meta);
        }
    }
}

