/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.item.crafting;

import com.pau101.fairylights.FairyLights;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeFairyLights
implements IRecipe {
    private int recipeWidth;
    private int recipeHeight;
    private Object[][] recipeItems;
    private Item outputItem;
    private ItemStack[] itemContained;
    private ItemStack recipeOutput;
    private List<UsedSlot> usedSlots;

    public RecipeFairyLights() {
        int i;
        Object[] recipe = new Object[]{"I-I", Character.valueOf('I'), "ingotIron", Character.valueOf('-'), new Object[]{Items.field_151007_F, "stickWood"}};
        this.outputItem = FairyLights.fairyLights;
        String recipeString = "";
        int slot = 0;
        if (recipe[slot] instanceof String[]) {
            String[] recipeRows = (String[])recipe[slot++];
            for (i = 0; i < recipeRows.length; ++i) {
                String recipeRow = recipeRows[i];
                ++this.recipeHeight;
                this.recipeWidth = recipeRow.length();
                recipeString = recipeString + recipeRow;
            }
        } else {
            while (recipe[slot] instanceof String) {
                String recipeRow = (String)recipe[slot++];
                ++this.recipeHeight;
                this.recipeWidth = recipeRow.length();
                recipeString = recipeString + recipeRow;
            }
        }
        HashMap ingredientMap = new HashMap();
        while (slot < recipe.length) {
            Character character = (Character)recipe[slot];
            ArrayList<Object> itemStacks = new ArrayList<Object>();
            if (recipe[slot + 1] instanceof Item) {
                itemStacks.add(new ItemStack((Item)recipe[slot + 1]));
            } else if (recipe[slot + 1] instanceof Block) {
                itemStacks.add(new ItemStack((Block)recipe[slot + 1], 1, Short.MAX_VALUE));
            } else if (recipe[slot + 1] instanceof ItemStack) {
                itemStacks.add(((ItemStack)recipe[slot + 1]).func_77946_l());
            } else if (recipe[slot + 1] instanceof Object[]) {
                Object[] objects = (Object[])recipe[slot + 1];
                for (int i2 = 0; i2 < objects.length; ++i2) {
                    Object object = objects[i2];
                    if (object instanceof Item) {
                        itemStacks.add(new ItemStack((Item)object));
                        continue;
                    }
                    if (object instanceof Block) {
                        itemStacks.add(new ItemStack((Block)object, 1, Short.MAX_VALUE));
                        continue;
                    }
                    if (object instanceof ItemStack) {
                        itemStacks.add(((ItemStack)object).func_77946_l());
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    itemStacks.add(OreDictionary.getOres((String)((String)object)));
                }
            } else if (recipe[slot + 1] instanceof String) {
                itemStacks.add(OreDictionary.getOres((String)((String)recipe[slot + 1])));
            }
            ingredientMap.put(character, itemStacks);
            slot += 2;
        }
        this.recipeItems = new Object[this.recipeWidth * this.recipeHeight][];
        for (i = 0; i < this.recipeWidth * this.recipeHeight; ++i) {
            char character = recipeString.charAt(i);
            if (ingredientMap.containsKey(Character.valueOf(character))) {
                List itemStackOptions = (List)ingredientMap.get(Character.valueOf(character));
                this.recipeItems[i] = new Object[itemStackOptions.size()];
                for (int n = 0; n < this.recipeItems[i].length; ++n) {
                    this.recipeItems[i][n] = itemStackOptions.get(n);
                }
                continue;
            }
            this.recipeItems[i] = null;
        }
    }

    private boolean checkMatch(InventoryCrafting inventoryCrafting, int offsetX, int offsetY, boolean mirror) {
        this.itemContained = new ItemStack[this.recipeWidth * this.recipeHeight];
        this.usedSlots = new ArrayList<UsedSlot>();
        for (int x = 0; x < this.recipeWidth; ++x) {
            for (int y = 0; y < this.recipeHeight; ++y) {
                Object[] itemStackinInv;
                int index;
                if (mirror) {
                    index = this.recipeWidth - x - 1 + y * this.recipeWidth;
                    itemStackinInv = this.recipeItems[index];
                } else {
                    index = x + y * this.recipeWidth;
                    itemStackinInv = this.recipeItems[index];
                }
                ItemStack itemStack = inventoryCrafting.func_70463_b(x + offsetX, y + offsetY);
                if (itemStack == null || !this.sharesItem(index, itemStack, itemStackinInv)) {
                    return false;
                }
                this.usedSlots.add(new UsedSlot(x + offsetX, y + offsetY));
            }
        }
        return true;
    }

    private boolean sharesItem(int index, ItemStack itemStack, Object ... options) {
        Item item = itemStack.func_77973_b();
        int damage = itemStack.func_77960_j();
        for (int i = 0; i < options.length; ++i) {
            Object option = options[i];
            if (option instanceof ItemStack) {
                ItemStack optionItem = (ItemStack)option;
                if (!OreDictionary.itemMatches((ItemStack)optionItem, (ItemStack)itemStack, (boolean)false)) continue;
                this.itemContained[index] = optionItem;
                return true;
            }
            if (!(option instanceof List)) continue;
            for (ItemStack optionItem : (List)option) {
                if (!OreDictionary.itemMatches((ItemStack)optionItem, (ItemStack)itemStack, (boolean)false)) continue;
                this.itemContained[index] = optionItem;
                return true;
            }
        }
        return false;
    }

    private boolean containsRecipe(InventoryCrafting inventoryCrafting) {
        for (int x = 0; x <= 3 - this.recipeWidth; ++x) {
            for (int y = 0; y <= 3 - this.recipeHeight; ++y) {
                if (!this.checkMatch(inventoryCrafting, x, y, true) && !this.checkMatch(inventoryCrafting, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return this.recipeOutput.func_77946_l();
    }

    private void getDetails(InventoryCrafting inventoryCrafting, World world, boolean rewriteLights) {
        this.recipeOutput = new ItemStack(this.outputItem, rewriteLights ? 1 : 2);
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList patternList = new NBTTagList();
        boolean twinkle = false;
        boolean tight = this.itemContained[1] != null && this.itemContained[1].func_77973_b() == Items.field_151055_y;
        boolean noExtraFairyLights = true;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack itemStack;
                if (this.usedSlots.contains(new UsedSlot(x, y)) || (itemStack = inventoryCrafting.func_70463_b(x, y)) == null) continue;
                Item item = itemStack.func_77973_b();
                if (item == FairyLights.light && itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("color", 3)) {
                    NBTTagCompound patternCompound = new NBTTagCompound();
                    patternCompound.func_74768_a("light", itemStack.func_77960_j());
                    patternCompound.func_74774_a("color", (byte)itemStack.func_77978_p().func_74762_e("color"));
                    patternList.func_74742_a((NBTBase)patternCompound);
                    continue;
                }
                if (item == Items.field_151114_aO) {
                    if (twinkle) {
                        this.recipeOutput = null;
                        return;
                    }
                    twinkle = true;
                    continue;
                }
                if (item == this.outputItem && noExtraFairyLights) {
                    NBTTagCompound existingCompound;
                    if (itemStack.func_77942_o() && (existingCompound = itemStack.func_77978_p()).func_150297_b("tight", 1)) {
                        tight = existingCompound.func_74767_n("tight");
                    }
                    noExtraFairyLights = false;
                    continue;
                }
                this.recipeOutput = null;
                return;
            }
        }
        if (patternList.func_74745_c() == 0) {
            this.recipeOutput = null;
            return;
        }
        tagCompound.func_74782_a("pattern", (NBTBase)patternList);
        tagCompound.func_74757_a("twinkle", twinkle);
        tagCompound.func_74757_a("tight", tight);
        this.recipeOutput.func_77982_d(tagCompound);
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public int func_77570_a() {
        return 10;
    }

    private boolean inventoryContains(IInventory inventory, Item item) {
        int size = inventory.func_70302_i_();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack itemStack = inventory.func_70301_a(slot);
            if (itemStack == null || itemStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        this.recipeOutput = null;
        if (this.containsRecipe(inventoryCrafting)) {
            this.getDetails(inventoryCrafting, world, false);
        } else if (this.inventoryContains((IInventory)inventoryCrafting, this.outputItem)) {
            this.getDetails(inventoryCrafting, world, true);
        }
        return this.recipeOutput != null;
    }

    private class UsedSlot {
        public int x;
        public int y;

        private UsedSlot(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UsedSlot other = (UsedSlot)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }
    }
}

