/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.player;

import com.pau101.fairylights.util.vectormath.Point3i;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerData {
    private static Map<EntityPlayer, PlayerData> playerMap = new WeakHashMap<EntityPlayer, PlayerData>();
    private static final Point3i UNKNOWN = new Point3i();
    private Point3i lastClicked;

    public static PlayerData getPlayerData(EntityPlayer player) {
        PlayerData data = playerMap.get(player);
        if (data == null && player != null) {
            data = new PlayerData();
            playerMap.put(player, data);
        }
        return data;
    }

    public static void update() {
        for (Map.Entry<EntityPlayer, PlayerData> dataEntry : playerMap.entrySet()) {
            Point3i lastClicked = dataEntry.getValue().lastClicked;
            if (dataEntry.getKey().field_70170_p.func_147438_o(lastClicked.x, lastClicked.y, lastClicked.z) != null) continue;
            dataEntry.getValue().lastClicked = UNKNOWN;
        }
    }

    public PlayerData() {
        this.setUnknownLastClicked();
    }

    public Point3i getLastClicked() {
        return this.lastClicked;
    }

    public boolean hasLastClicked() {
        return this.lastClicked != UNKNOWN;
    }

    public void setLastClicked(int x, int y, int z) {
        this.lastClicked = new Point3i(x, y, z);
    }

    public void setUnknownLastClicked() {
        this.lastClicked = UNKNOWN;
    }
}

