/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.tileentity;

import com.google.common.base.Charsets;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.block.BlockConnectionFastener;
import com.pau101.fairylights.connection.ConnectionType;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.tileentity.connection.ConnectionFastener;
import com.pau101.fairylights.tileentity.connection.ConnectionPlayer;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.MathUtils;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.vectormath.Point3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityConnectionFastener
extends TileEntity {
    private Map<UUID, Connection> connections = new HashMap<UUID, Connection>();
    private Point3f min = new Point3f();
    private Point3f max = new Point3f();
    private Point3f connectionPoint = null;

    private void calculateBoundingBox() {
        this.min = new Point3f(Float.NaN, 0.0f, 0.0f);
        this.max = new Point3f(Float.NaN, 0.0f, 0.0f);
        for (Connection connection : this.connections.values()) {
            Catenary catenary;
            if (!connection.isOrigin() || (catenary = connection.getCatenary()) == null) continue;
            Segment[] segments = catenary.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                Segment segment = segments[i];
                Point3f vertex = segment.getVertex();
                MathUtils.minmax(this.min, this.max, vertex.x / 16.0f, vertex.y / 16.0f, vertex.z / 16.0f);
            }
            Point3f vertex = segments[segments.length - 1].pointAt(1.0f);
            MathUtils.minmax(this.min, this.max, vertex.x / 16.0f, vertex.y / 16.0f, vertex.z / 16.0f);
        }
        if (this.min.x != this.min.x) {
            this.min.x = 0.0f;
            this.max.x = 0.0f;
        }
    }

    public boolean hasConnectionWith(TileEntityConnectionFastener fastener) {
        for (Connection connection : this.connections.values()) {
            if (connection.getToX() != fastener.field_145851_c || connection.getToY() != fastener.field_145848_d || connection.getToZ() != fastener.field_145849_e) continue;
            return true;
        }
        return false;
    }

    public void connectWith(EntityPlayer entity, ConnectionType type, NBTTagCompound tagCompound) {
        this.connections.put(UUID.randomUUID(), new ConnectionPlayer(type, this, this.field_145850_b, entity, tagCompound));
    }

    public void connectWith(TileEntityConnectionFastener fairyLightsFastener, ConnectionType type, NBTTagCompound tagCompound) {
        this.connections.put(UUID.randomUUID(), new ConnectionFastener(type, this, this.field_145850_b, fairyLightsFastener.field_145851_c, fairyLightsFastener.field_145848_d, fairyLightsFastener.field_145849_e, true, tagCompound));
        fairyLightsFastener.connections.put(UUID.randomUUID(), new ConnectionFastener(type, this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false, tagCompound));
    }

    public Point3f getConnectionPoint() {
        if (this.connectionPoint == null) {
            this.connectionPoint = ((BlockConnectionFastener)this.func_145838_q()).getOffsetForData(this.func_145832_p(), 0.125f).add(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.connectionPoint;
    }

    public Set<Map.Entry<UUID, Connection>> getConnectionEntrySet() {
        return this.connections.entrySet();
    }

    public Collection<Connection> getConnections() {
        return this.connections.values();
    }

    public Connection getConnection(UUID uuid) {
        return this.connections.get(uuid);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public AxisAlignedBB getBoundingBox() {
        Point3f fromOffset = this.getConnectionPoint();
        return AxisAlignedBB.func_72330_a((double)this.min.x, (double)this.min.y, (double)this.min.z, (double)this.max.x, (double)this.max.y, (double)this.max.z).func_72314_b(0.75, 2.0, 0.75).func_72317_d((double)fromOffset.x, (double)fromOffset.y, (double)fromOffset.z);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void removeConnection(Entity entity) {
        for (Connection connection : this.connections.values()) {
            if (!(connection instanceof ConnectionPlayer) || !entity.func_110124_au().equals(((ConnectionPlayer)connection).getPlayerUUID()) && (!(entity instanceof EntityPlayer) || !UUID.nameUUIDFromBytes(("OfflinePlayer:" + ((EntityPlayer)entity).func_146103_bH().getName()).getBytes(Charsets.UTF_8)).equals(((ConnectionPlayer)connection).getPlayerUUID()))) continue;
            ((ConnectionPlayer)connection).forceRemove = true;
        }
    }

    public void func_145834_a(World worldObj) {
        super.func_145834_a(worldObj);
        for (Connection connection : this.connections.values()) {
            connection.setWorldObj(worldObj);
        }
    }

    public void func_145845_h() {
        if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockConnectionFastener)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.connections.size() == 0) {
            if (this.func_145838_q() == FairyLights.fastenerFence) {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150422_aJ);
            } else {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return;
        }
        Iterator<Connection> connectionIterator = this.connections.values().iterator();
        Point3f fromOffset = this.getConnectionPoint();
        boolean update = false;
        boolean playerUpdateBoundingBox = false;
        while (connectionIterator.hasNext()) {
            Connection connection = connectionIterator.next();
            update |= connection.shouldRecalculateCatenery();
            connection.update(fromOffset);
            if (this.field_145850_b.field_72995_K && connection instanceof ConnectionPlayer) {
                playerUpdateBoundingBox = true;
            }
            if (!connection.shouldDisconnect()) continue;
            update = true;
            connection.onRemove();
            connectionIterator.remove();
        }
        if (update || playerUpdateBoundingBox) {
            this.calculateBoundingBox();
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList listConnections = new NBTTagList();
        for (Map.Entry<UUID, Connection> connectionEntry : this.connections.entrySet()) {
            UUID uuid = connectionEntry.getKey();
            Connection connection = connectionEntry.getValue();
            NBTTagCompound connectionCompound = new NBTTagCompound();
            connection.writeToNBT(connectionCompound);
            connectionCompound.func_74768_a("type", connection.getType().ordinal());
            connectionCompound.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
            connectionCompound.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
            listConnections.func_74742_a((NBTBase)connectionCompound);
        }
        compound.func_74782_a("connections", (NBTBase)listConnections);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("connections", 9)) {
            NBTTagList listConnections = compound.func_150295_c("connections", 10);
            ArrayList<UUID> nbtUUIDs = new ArrayList<UUID>();
            for (int i = 0; i < listConnections.func_74745_c(); ++i) {
                Connection connection;
                NBTTagCompound connectionCompound = listConnections.func_150305_b(i);
                UUID uuid = connectionCompound.func_150297_b("UUIDMost", 4) && connectionCompound.func_150297_b("UUIDLeast", 4) ? new UUID(connectionCompound.func_74763_f("UUIDMost"), connectionCompound.func_74763_f("UUIDLeast")) : UUID.randomUUID();
                nbtUUIDs.add(uuid);
                if (this.connections.containsKey(uuid)) continue;
                ConnectionType type = ConnectionType.from(connectionCompound.func_74762_e("type"));
                if (connectionCompound.func_150297_b("PlayerUUIDMost", 4) && connectionCompound.func_150297_b("PlayerUUIDLeast", 4)) {
                    connection = new ConnectionPlayer(type, this, this.field_145850_b);
                } else {
                    if (!connectionCompound.func_150297_b("x", 99) || !connectionCompound.func_150297_b("y", 99) || !connectionCompound.func_150297_b("z", 99)) continue;
                    connection = new ConnectionFastener(type, this, this.field_145850_b);
                }
                ((Connection)connection).readFromNBT(connectionCompound);
                this.connections.put(uuid, connection);
            }
            Iterator<UUID> currentUUIDsIterator = this.connections.keySet().iterator();
            while (currentUUIDsIterator.hasNext()) {
                UUID uuid = currentUUIDsIterator.next();
                if (nbtUUIDs.contains(uuid)) continue;
                currentUUIDsIterator.remove();
            }
        }
    }
}

