/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.tileentity.connection;

import com.pau101.fairylights.connection.ConnectionLogic;
import com.pau101.fairylights.connection.ConnectionType;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.util.Catenary;
import com.pau101.fairylights.util.vectormath.Point3f;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Connection {
    protected TileEntityConnectionFastener fastener;
    protected World worldObj;
    private boolean isOrigin;
    private Catenary catenary;
    private Catenary prevCatenary;
    private Light[] lightPoints;
    protected boolean shouldRecalculateCatenary;
    private int toX;
    private int toY;
    private int toZ;
    private int fromX;
    private int fromY;
    private int fromZ;
    private boolean isDirty;
    private final ConnectionType type;
    private final ConnectionLogic logic;

    public Connection(ConnectionType type, TileEntityConnectionFastener fairyLightsFastener, World worldObj) {
        this(type, fairyLightsFastener, worldObj, false, null);
    }

    public Connection(ConnectionType type, TileEntityConnectionFastener fastener, World worldObj, boolean isOrigin, NBTTagCompound compound) {
        this.type = type;
        this.fastener = fastener;
        this.setWorldObj(worldObj);
        this.isOrigin = isOrigin;
        this.shouldRecalculateCatenary = true;
        this.logic = type.createLogic(this);
        if (compound != null) {
            this.readDetailsFromNBT(compound);
        }
    }

    public Catenary getCatenary() {
        return this.catenary;
    }

    public Catenary getPrevCatenary() {
        return this.prevCatenary;
    }

    public final ConnectionType getType() {
        return this.type;
    }

    public final ConnectionLogic getLogic() {
        return this.logic;
    }

    public abstract Point3f getTo();

    public abstract int getToX();

    public abstract int getToY();

    public abstract int getToZ();

    public void setWorldObj(World worldObj) {
        this.worldObj = worldObj;
    }

    public World getWorldObj() {
        return this.worldObj;
    }

    public boolean isOrigin() {
        return this.isOrigin;
    }

    public boolean shouldRecalculateCatenery() {
        return this.shouldRecalculateCatenary;
    }

    public TileEntityConnectionFastener getFastener() {
        return this.fastener;
    }

    public void onRemove() {
    }

    public abstract boolean shouldDisconnect();

    public void update(Point3f from) {
        this.prevCatenary = this.catenary;
        this.logic.onUpdate();
        if (this.shouldRecalculateCatenary) {
            Point3f to = this.getTo();
            if (to == null) {
                return;
            }
            to.sub(from);
            if (to.x == 0.0f && to.y == 0.0f && to.z == 0.0f) {
                return;
            }
            this.fromX = this.fastener.field_145851_c;
            this.fromY = this.fastener.field_145848_d;
            this.fromZ = this.fastener.field_145849_e;
            this.toX = this.getToX();
            this.toY = this.getToY();
            this.toZ = this.getToZ();
            this.catenary = this.logic.createCatenary(to);
            this.shouldRecalculateCatenary = false;
            this.logic.onRecalculateCatenary();
        }
        this.logic.onUpdateEnd();
    }

    public void writeDetailsToNBT(NBTTagCompound compound) {
        this.logic.writeToNBT(compound);
    }

    public void readDetailsFromNBT(NBTTagCompound compound) {
        this.logic.readFromNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.isOrigin = compound.func_74767_n("isOrigin");
        this.isDirty = compound.func_74767_n("isDirty");
        this.readDetailsFromNBT(compound);
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("isOrigin", this.isOrigin);
        compound.func_74757_a("isDirty", this.isDirty);
        this.writeDetailsToNBT(compound);
    }
}

