/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.tileentity.connection;

import com.pau101.fairylights.block.BlockConnectionFastener;
import com.pau101.fairylights.connection.ConnectionType;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.util.vectormath.Point3f;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ConnectionFastener
extends Connection {
    private int toX;
    private int toY;
    private int toZ;

    public ConnectionFastener(ConnectionType type, TileEntityConnectionFastener fairyLightsFastener, World worldObj) {
        super(type, fairyLightsFastener, worldObj);
    }

    public ConnectionFastener(ConnectionType type, TileEntityConnectionFastener fairyLightsFastener, World worldObj, int toX, int toY, int toZ, boolean isOrigin, NBTTagCompound tagCompound) {
        super(type, fairyLightsFastener, worldObj, isOrigin, tagCompound);
        this.toX = toX;
        this.toY = toY;
        this.toZ = toZ;
    }

    @Override
    public Point3f getTo() {
        Block toBlock = this.worldObj.func_147439_a(this.toX, this.toY, this.toZ);
        if (!(toBlock instanceof BlockConnectionFastener)) {
            return null;
        }
        Point3f point = ((BlockConnectionFastener)toBlock).getOffsetForData(this.worldObj.func_72805_g(this.toX, this.toY, this.toZ), 0.125f);
        point.x += (float)this.toX;
        point.y += (float)this.toY;
        point.z += (float)this.toZ;
        return point;
    }

    @Override
    public int getToX() {
        return this.toX;
    }

    @Override
    public int getToY() {
        return this.toY;
    }

    @Override
    public int getToZ() {
        return this.toZ;
    }

    @Override
    public boolean shouldDisconnect() {
        return this.worldObj.func_72899_e(this.toX, this.toY, this.toZ) && !(this.worldObj.func_147438_o(this.toX, this.toY, this.toZ) instanceof TileEntityConnectionFastener);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("x", this.toX);
        compound.func_74768_a("y", this.toY);
        compound.func_74768_a("z", this.toZ);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.toX = compound.func_74762_e("x");
        this.toY = compound.func_74762_e("y");
        this.toZ = compound.func_74762_e("z");
    }
}

