/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.tileentity.connection;

import com.google.common.base.Charsets;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.connection.ConnectionType;
import com.pau101.fairylights.item.ItemConnection;
import com.pau101.fairylights.player.PlayerData;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Point3i;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ConnectionPlayer
extends Connection {
    private EntityPlayer player;
    private UUID entityUUID;
    public boolean forceRemove;
    private NBTTagCompound details;
    private int prevStretchStage;

    public ConnectionPlayer(ConnectionType type, TileEntityConnectionFastener fairyLightsFastener, World worldObj) {
        super(type, fairyLightsFastener, worldObj);
    }

    public ConnectionPlayer(ConnectionType type, TileEntityConnectionFastener fairyLightsFastener, World worldObj, EntityPlayer player, NBTTagCompound tagCompound) {
        super(type, fairyLightsFastener, worldObj, true, tagCompound);
        this.player = player;
        this.setPlayerUUID(player.func_110124_au());
        this.forceRemove = false;
    }

    @Override
    public Point3f getTo() {
        if (this.player == null) {
            return null;
        }
        Point3f point = new Point3f((float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v);
        point.x += MathHelper.func_76134_b((float)((this.player.field_70760_ar - 180.0f) / 180.0f * (float)Math.PI)) * 0.4f;
        point.z += MathHelper.func_76126_a((float)((this.player.field_70760_ar - 180.0f) / 180.0f * (float)Math.PI)) * 0.4f;
        point.y += FairyLights.proxy.getCatenaryOffset(this.player);
        return point;
    }

    @Override
    public int getToX() {
        Point3f to = this.getTo();
        if (to == null) {
            return 0;
        }
        return MathHelper.func_76141_d((float)to.x);
    }

    @Override
    public int getToY() {
        Point3f to = this.getTo();
        if (to == null) {
            return 0;
        }
        return MathHelper.func_76141_d((float)to.y);
    }

    @Override
    public int getToZ() {
        Point3f to = this.getTo();
        if (to == null) {
            return 0;
        }
        return MathHelper.func_76141_d((float)to.z);
    }

    @Override
    public void onRemove() {
        super.onRemove();
        PlayerData data = PlayerData.getPlayerData(this.player);
        data.setUnknownLastClicked();
    }

    @Override
    public boolean shouldDisconnect() {
        return this.player != null && this.player.field_70128_L || this.forceRemove;
    }

    public void setPlayerUUID(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public UUID getPlayerUUID() {
        return this.entityUUID;
    }

    @Override
    public void update(Point3f from) {
        this.shouldRecalculateCatenary = true;
        super.update(from);
        if (this.player == null) {
            List nearEntities = this.worldObj.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.fastener.field_145851_c, (double)this.fastener.field_145848_d, (double)this.fastener.field_145849_e, (double)(this.fastener.field_145851_c + 1), (double)(this.fastener.field_145848_d + 1), (double)(this.fastener.field_145849_e + 1)).func_72314_b(20.0, 20.0, 20.0));
            for (EntityPlayer entity : nearEntities) {
                if (!entity.func_110124_au().equals(this.getPlayerUUID()) && !UUID.nameUUIDFromBytes(("OfflinePlayer:" + entity.func_146103_bH().getName()).getBytes(Charsets.UTF_8)).equals(this.getPlayerUUID())) continue;
                this.player = entity;
                PlayerData data = PlayerData.getPlayerData(entity);
                data.setLastClicked(this.fastener.field_145851_c, this.fastener.field_145848_d, this.fastener.field_145849_e);
                return;
            }
        } else {
            PlayerData data = PlayerData.getPlayerData(this.player);
            Point3i point = data.getLastClicked();
            if (this.details == null) {
                this.details = new NBTTagCompound();
                this.writeDetailsToNBT(this.details);
            }
            if (!this.worldObj.field_72995_K) {
                double dist = this.distance((Entity)this.player, from);
                if (dist - 15.0 > 0.0) {
                    int stage = (int)(dist - (double)14.9f);
                    if (stage > this.prevStretchStage) {
                        this.player.field_70170_p.func_72908_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, "fairylights:cord.creak", 0.25f, 0.5f + (float)stage / 8.0f);
                    }
                    this.prevStretchStage = stage;
                }
                if (dist > 25.0) {
                    this.player.field_70170_p.func_72908_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, "fairylights:cord.break", 0.75f, 0.8f);
                    this.forceRemove = true;
                    return;
                }
                if (dist > 20.0) {
                    double vectorX = (this.player.field_70165_t - (double)from.x) / dist;
                    double vectorY = (this.player.field_70163_u - (double)from.y) / dist;
                    double vectorZ = (this.player.field_70161_v - (double)from.z) / dist;
                    this.player.field_70159_w += vectorX * Math.abs(vectorX) * -0.1;
                    this.player.field_70181_x += vectorY * Math.abs(vectorY) * -0.1;
                    this.player.field_70179_y += vectorZ * Math.abs(vectorZ) * -0.1;
                    this.player.field_70143_R = 0.0f;
                    ((EntityPlayerMP)this.player).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)this.player));
                }
            }
            if (point.x != this.fastener.field_145851_c || point.y != this.fastener.field_145848_d || point.z != this.fastener.field_145849_e || this.player.func_70694_bm() == null || !(this.player.func_70694_bm().func_77973_b() instanceof ItemConnection) || !((ItemConnection)this.player.func_70694_bm().func_77973_b()).getConnectionType().isConnectionThis(this) || this.player.func_70694_bm().func_77942_o() && !this.player.func_70694_bm().func_77978_p().equals((Object)this.details)) {
                this.forceRemove = true;
            }
        }
    }

    private float distance(Entity entity, Point3f point) {
        float x = (float)(entity.field_70165_t - (double)point.x);
        float y = (float)(entity.field_70163_u - (double)point.y);
        float z = (float)(entity.field_70161_v - (double)point.z);
        return MathHelper.func_76129_c((float)(x * x + y * y + z * z));
    }

    private float distancePrev(Entity entity, Point3f point) {
        float x = (float)(entity.field_70169_q - (double)point.x);
        float y = (float)(entity.field_70167_r - (double)point.y);
        float z = (float)(entity.field_70166_s - (double)point.z);
        return MathHelper.func_76129_c((float)(x * x + y * y + z * z));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74772_a("PlayerUUIDMost", this.getPlayerUUID().getMostSignificantBits());
        compound.func_74772_a("PlayerUUIDLeast", this.getPlayerUUID().getLeastSignificantBits());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.setPlayerUUID(new UUID(compound.func_74763_f("PlayerUUIDMost"), compound.func_74763_f("PlayerUUIDLeast")));
    }
}

