/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

public final class BezierUtils {
    private BezierUtils() {
    }

    public static void allBernstein(int curveDegree, float t, float[] scalars) {
        float nt = 1.0f - t;
        scalars[0] = 1.0f;
        for (int j = 1; j <= curveDegree; ++j) {
            float saved = 0.0f;
            for (int k = 0; k < j; ++k) {
                float temp = scalars[k];
                scalars[k] = saved + nt * temp;
                saved = t * temp;
            }
            scalars[j] = saved;
        }
    }

    public static void pointOnBezierCurve(float[][] controlPoints, int curveDegree, float t, float[] point) {
        float[] scalars = new float[curveDegree + 1];
        BezierUtils.allBernstein(curveDegree, t, scalars);
        point[2] = 0.0f;
        point[1] = 0.0f;
        point[0] = 0.0f;
        for (int k = 0; k <= curveDegree; ++k) {
            point[0] = point[0] + scalars[k] * controlPoints[k][0];
            point[1] = point[1] + scalars[k] * controlPoints[k][1];
            point[2] = point[2] + scalars[k] * controlPoints[k][2];
        }
    }

    public static float approximateLength(float[][] controlPoints) {
        float length = 0.0f;
        for (int i = 0; i < controlPoints.length - 1; ++i) {
            float xDif = controlPoints[i + 1][0] - controlPoints[i][0];
            float yDif = controlPoints[i + 1][1] - controlPoints[i][1];
            float zDif = controlPoints[i + 1][2] - controlPoints[i][2];
            length = (float)((double)length + Math.sqrt(xDif * xDif + yDif * yDif + zDif * zDif));
        }
        return length;
    }

    public static int tesselationSegementsForLength(float length, float scale) {
        float noLessThan = 10.0f * scale;
        float segs = length * scale / 30.0f;
        return (int)Math.ceil(Math.sqrt((double)(segs * segs) * 0.6 + (double)(noLessThan * noLessThan)));
    }

    public static float[][] curve(float[][] controlPoints) {
        return BezierUtils.curve(controlPoints, 1.0f);
    }

    public static float[][] curve(float[][] controlPoints, float scale) {
        int count = BezierUtils.tesselationSegementsForLength(BezierUtils.approximateLength(controlPoints), scale);
        float[][] points = new float[count][3];
        for (int i = 0; i < count; ++i) {
            float t = (float)i / (float)(count - 1);
            float[] point = new float[3];
            BezierUtils.pointOnBezierCurve(controlPoints, controlPoints.length - 1, t, point);
            points[i] = point;
        }
        return points;
    }
}

