/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.pau101.fairylights.util.CatenaryUtils;
import com.pau101.fairylights.util.Segment;
import com.pau101.fairylights.util.vectormath.Point3f;
import com.pau101.fairylights.util.vectormath.Vector3f;
import net.minecraft.util.MathHelper;

public class Catenary {
    private static final float RATE = -0.005f;
    private Segment[] segments;
    private float length = 0.0f;

    private Catenary() {
    }

    public float getLength() {
        return this.length;
    }

    public Segment[] getSegments() {
        return this.segments;
    }

    private static float lengthFunc(float length) {
        return length * (length * -0.005f + 1.1f);
    }

    public static Catenary from(Vector3f direction, boolean tight) {
        return Catenary.from(direction, tight ? direction.length() : Catenary.lengthFunc(direction.length()));
    }

    public static Catenary from(Vector3f direction, float length) {
        Catenary catenary = new Catenary();
        float rotation = (float)Math.atan2(direction.z, direction.x);
        int vertexCount = (int)(length * 3.0f);
        if (vertexCount < 8) {
            vertexCount = 8;
        }
        float[][] vertices2D = CatenaryUtils.catenary(new float[]{0.0f, 0.0f}, new float[]{MathHelper.func_76129_c((float)(direction.x * direction.x + direction.z * direction.z)), direction.y}, length, vertexCount);
        catenary.segments = new Segment[vertices2D[0].length - 1];
        float[] xCoords = vertices2D[0];
        float[] yCoords = vertices2D[1];
        float rotationCos = MathHelper.func_76134_b((float)rotation);
        float rotationSin = MathHelper.func_76126_a((float)rotation);
        float scale = 16.0f;
        for (int i = 0; i < xCoords.length; ++i) {
            Point3f vertex = new Point3f(xCoords[i] * rotationCos * scale, yCoords[i] * scale, xCoords[i] * rotationSin * scale);
            if (i < xCoords.length - 1) {
                catenary.segments[i] = new Segment(vertex);
            }
            if (i <= 0) continue;
            Segment segment = catenary.segments[i - 1];
            segment.connectTo(vertex);
            catenary.length += segment.getLength();
        }
        return catenary;
    }
}

