/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.pau101.fairylights.util.BezierUtils;

public class CubicBezier {
    private float a1;
    private float b1;
    private float a2;
    private float b2;
    private float[][] controlPoints;

    public CubicBezier(float a1, float b1, float a2, float b2) {
        this.a1 = a1;
        this.b1 = b1;
        this.a2 = a2;
        this.b2 = b2;
        this.controlPoints = new float[4][];
        this.controlPoints[0] = new float[]{0.0f, 0.0f};
        this.controlPoints[1] = new float[]{a1, b1};
        this.controlPoints[2] = new float[]{a2, b2};
        this.controlPoints[3] = new float[]{1.0f, 1.0f};
    }

    public float eval(float t) {
        float[] scalars = new float[4];
        BezierUtils.allBernstein(3, t, scalars);
        float p = 0.0f;
        for (int i = 0; i < 4; ++i) {
            p += scalars[i] * this.controlPoints[i][1];
        }
        return p;
    }
}

