/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.pau101.fairylights.util.vectormath.Point3f;
import net.minecraft.util.MathHelper;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TAU = (float)Math.PI * 2;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.29578f;

    private MathUtils() {
    }

    public static int modi(int a, int b) {
        return (a % b + b) % b;
    }

    public static float modf(float a, float b) {
        return (a % b + b) % b;
    }

    public static float linearTransformf(float x, float domainMin, float domainMax, float rangeMin, float rangeMax) {
        x = x < domainMin ? domainMin : (x > domainMax ? domainMax : x);
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }

    public static float[] toEuler(float x, float y, float z, float angle) {
        float s = MathHelper.func_76126_a((float)angle);
        float c = MathHelper.func_76134_b((float)angle);
        float t = 1.0f - c;
        float magnitude = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
        if (magnitude == 0.0f) {
            throw new Error("Ubiquitous vector!");
        }
        if ((x /= magnitude) * (y /= magnitude) * t + (z /= magnitude) * s > 0.998f) {
            float pitch = (float)(2.0 * Math.atan2((double)x * Math.sin(angle / 2.0f), Math.cos(angle / 2.0f)));
            float yaw = 1.5707964f;
            float roll = 0.0f;
            return new float[]{roll, pitch, yaw};
        }
        if (x * y * t + z * s < -0.998f) {
            float pitch = (float)(-2.0 * Math.atan2((double)x * Math.sin(angle / 2.0f), Math.cos(angle / 2.0f)));
            float yaw = -1.5707964f;
            float roll = 0.0f;
            return new float[]{roll, pitch, yaw};
        }
        float pitch = (float)Math.atan2(y * s - x * z * t, 1.0f - (y * y + z * z) * t);
        float yaw = (float)Math.asin(x * y * t + z * s);
        float roll = (float)Math.atan2(x * s - y * z * t, 1.0f - (x * x + z * z) * t);
        return new float[]{roll, pitch, yaw};
    }

    public static int hash(int x) {
        x = (x >> 16 ^ x) * 73244475;
        x = (x >> 16 ^ x) * 73244475;
        x = x >> 16 ^ x;
        return x;
    }

    public static void minmax(Point3f min, Point3f max, float x, float y, float z) {
        if (min.x != min.x) {
            min.x = x;
            min.y = y;
            min.z = z;
        }
        if (max.x != max.x) {
            max.x = x;
            max.y = y;
            max.z = z;
        }
        min.x = x < min.x ? x : min.x;
        min.y = y < min.y ? y : min.y;
        min.z = z < min.z ? z : min.z;
        max.x = x > max.x ? x : max.x;
        max.y = y > max.y ? y : max.y;
        max.z = z > max.z ? z : max.z;
    }
}

