/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.vectormath;

import com.pau101.fairylights.util.vectormath.Tuple3f;

public class Point3f
extends Tuple3f {
    public Point3f() {
    }

    public Point3f(float x, float y, float z) {
        super(x, y, z);
    }

    public Point3f(Point3f p1) {
        super(p1);
    }

    public Point3f add(float x, float y, float z) {
        return new Point3f(this.x + x, this.y + y, this.z + z);
    }

    public void add(Point3f point) {
        this.x += point.x;
        this.y += point.y;
        this.z += point.z;
    }

    public final float distance(Point3f p1) {
        float dx = this.x - p1.x;
        float dy = this.y - p1.y;
        float dz = this.z - p1.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point3f other = (Point3f)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }
}

