/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.vectormath;

public abstract class Tuple3f {
    public float x;
    public float y;
    public float z;

    public Tuple3f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Tuple3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Tuple3f(Tuple3f t1) {
        this.x = t1.x;
        this.y = t1.y;
        this.z = t1.z;
    }

    public boolean equals(Tuple3f t1) {
        try {
            return this.x == t1.x && this.y == t1.y && this.z == t1.z;
        }
        catch (NullPointerException e2) {
            return false;
        }
    }

    public final void interpolate(Tuple3f t1, float alpha) {
        this.interpolate(t1, alpha, false);
    }

    public final void interpolate(Tuple3f t1, float alpha, boolean angle) {
        if (angle) {
            this.x = this.lerpa(this.x, t1.x, alpha);
            this.y = this.lerpa(this.y, t1.y, alpha);
            this.z = this.lerpa(this.z, t1.z, alpha);
        } else {
            this.x = (1.0f - alpha) * this.x + alpha * t1.x;
            this.y = (1.0f - alpha) * this.y + alpha * t1.y;
            this.z = (1.0f - alpha) * this.z + alpha * t1.z;
        }
    }

    private final float lerpa(float start, float end, float amount) {
        float difference = Math.abs(end - start);
        if ((double)difference > Math.PI) {
            if (end > start) {
                start = (float)((double)start + Math.PI * 2);
            } else {
                end = (float)((double)end + Math.PI * 2);
            }
        }
        float value = start + (end - start) * amount;
        float rangeZero = (float)Math.PI * 2;
        if (value >= 0.0f && (double)value <= Math.PI * 2) {
            return value;
        }
        return value % rangeZero;
    }

    public final void sub(Tuple3f t1) {
        this.x -= t1.x;
        this.y -= t1.y;
        this.z -= t1.z;
    }
}

