/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.world;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.config.Configurator;
import com.pau101.fairylights.connection.ConnectionLogicFairyLights;
import com.pau101.fairylights.connection.Light;
import com.pau101.fairylights.eggs.Jingle;
import com.pau101.fairylights.network.play.server.S00FLPacketJingle;
import com.pau101.fairylights.player.PlayerData;
import com.pau101.fairylights.tileentity.TileEntityConnectionFastener;
import com.pau101.fairylights.tileentity.connection.Connection;
import com.pau101.fairylights.tileentity.connection.ConnectionPlayer;
import com.pau101.fairylights.util.vectormath.Point3f;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TickHandler {
    private Random random = new Random();
    private float jingleProbability = 1.6666666E-4f;

    private List<Point3f> getPlayingLightSources(Map<TileEntityConnectionFastener, List<Map.Entry<UUID, Connection>>> feasibleConnections, TileEntityConnectionFastener fastener) {
        ArrayList<Point3f> points = new ArrayList<Point3f>();
        double expandAmount = Configurator.jingleAmplitude;
        AxisAlignedBB listenerRegion = fastener.getBoundingBox().func_72314_b(expandAmount, expandAmount, expandAmount);
        List nearPlayers = fastener.func_145831_w().func_72872_a(EntityPlayer.class, listenerRegion);
        boolean arePlayersNear = nearPlayers.size() > 0;
        for (Map.Entry<UUID, Connection> connectionEntry : fastener.getConnectionEntrySet()) {
            ConnectionLogicFairyLights connectionLogic;
            Light[] lightPoints;
            int range;
            Connection connection = connectionEntry.getValue();
            if (!connection.isOrigin() || connection instanceof ConnectionPlayer || !(connection.getLogic() instanceof ConnectionLogicFairyLights) || (range = (lightPoints = (connectionLogic = (ConnectionLogicFairyLights)connection.getLogic()).getLightPoints()) == null ? 0 : lightPoints.length) < Jingle.getMinRange()) continue;
            if (connectionLogic.canCurrentlyPlayAJingle()) {
                if (!arePlayersNear) continue;
                if (feasibleConnections.containsKey((Object)fastener)) {
                    feasibleConnections.get((Object)fastener).add(connectionEntry);
                    continue;
                }
                ArrayList<Map.Entry<UUID, Connection>> connections = new ArrayList<Map.Entry<UUID, Connection>>();
                connections.add(connectionEntry);
                feasibleConnections.put(fastener, connections);
                continue;
            }
            for (Light light : lightPoints) {
                points.add(light.getAbsolutePoint(fastener));
            }
        }
        return points;
    }

    public boolean isTooCloseTo(TileEntityConnectionFastener fastener, Light[] lights, List<Point3f> playingSources) {
        for (Light light : lights) {
            for (Point3f point : playingSources) {
                if (!(light.getAbsolutePoint(fastener).distance(point) <= (float)Configurator.jingleAmplitude)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        PlayerData.update();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.world != null && FairyLights.christmas.isOcurringNow() && Configurator.jingleEnabled && this.random.nextFloat() < this.jingleProbability) {
            int lightOffset;
            Jingle jingle;
            List connections;
            TileEntityConnectionFastener fastener;
            List tileEntities = event.world.field_147482_g;
            ArrayList<Point3f> playingSources = new ArrayList<Point3f>();
            HashMap<TileEntityConnectionFastener, List<Map.Entry<UUID, Connection>>> feasibleConnections = new HashMap<TileEntityConnectionFastener, List<Map.Entry<UUID, Connection>>>();
            for (TileEntity tileEntity : tileEntities) {
                TileEntityConnectionFastener fastener2;
                List<Point3f> newPlayingSources;
                if (!(tileEntity instanceof TileEntityConnectionFastener) || (newPlayingSources = this.getPlayingLightSources(feasibleConnections, fastener2 = (TileEntityConnectionFastener)tileEntity)) == null || newPlayingSources.size() <= 0) continue;
                playingSources.addAll(newPlayingSources);
            }
            Iterator feasibleFasteners = feasibleConnections.keySet().iterator();
            while (feasibleFasteners.hasNext()) {
                fastener = (TileEntityConnectionFastener)((Object)feasibleFasteners.next());
                connections = (List)feasibleConnections.get((Object)fastener);
                Iterator connectionIterator = connections.iterator();
                while (connectionIterator.hasNext()) {
                    Connection connection = (Connection)((Map.Entry)connectionIterator.next()).getValue();
                    if (!this.isTooCloseTo(fastener, ((ConnectionLogicFairyLights)connection.getLogic()).getLightPoints(), playingSources)) continue;
                    connectionIterator.remove();
                }
                if (connections.size() != 0) continue;
                feasibleFasteners.remove();
            }
            if (feasibleConnections.size() == 0) {
                return;
            }
            fastener = feasibleConnections.keySet().toArray(new TileEntityConnectionFastener[0])[this.random.nextInt(feasibleConnections.size())];
            connections = (List)feasibleConnections.get((Object)fastener);
            Map.Entry connectionEntry = (Map.Entry)connections.get(this.random.nextInt(connections.size()));
            UUID uuid = (UUID)connectionEntry.getKey();
            Connection connection = (Connection)connectionEntry.getValue();
            Light[] lightPoints = ((ConnectionLogicFairyLights)connection.getLogic()).getLightPoints();
            if (lightPoints != null && (jingle = Jingle.getRandomJingle(lightOffset = lightPoints.length)) != null) {
                lightOffset = lightOffset / 2 - jingle.getRange() / 2;
                ((ConnectionLogicFairyLights)connection.getLogic()).play(jingle, lightOffset);
                FairyLights.networkManager.sendPacketToClientsWatchingChunk(fastener.field_145851_c, fastener.field_145849_e, event.world, new S00FLPacketJingle(fastener, uuid, lightOffset, jingle), new Entity[0]);
            }
        }
    }
}

