/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.integration.jei;

import com.google.common.collect.ImmutableList;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import com.pau101.fairylights.util.crafting.ingredient.Ingredient;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliary;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegular;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public final class GenericRecipeWrapper
extends BlankRecipeWrapper
implements IShapedCraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final GenericRecipe recipe;
    private final ImmutableList<ImmutableList<ItemStack>> allInputs;
    private final ImmutableList<ImmutableList<ItemStack>> minimalInputStacks;
    private final ImmutableList<ItemStack> outputs;
    private final Ingredient<?, ?>[] ingredientMatrix;
    private final int subtypeIndex;

    public GenericRecipeWrapper(GenericRecipe recipe) {
        this.recipe = recipe;
        ImmutableList.Builder allInputs = ImmutableList.builder();
        ImmutableList.Builder minimalInputStacks = ImmutableList.builder();
        IngredientRegular[] ingredients = recipe.getIngredients();
        IngredientAuxiliary<?>[] aux = recipe.getAuxiliaryIngredients();
        this.ingredientMatrix = new Ingredient[9];
        int subtypeIndex = -1;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            Ingredient<IngredientRegular, GenericRecipe.MatchResultRegular> ingredient;
            ImmutableList<ItemStack> ingInputs;
            int x = i % 3;
            int y = i / 3;
            boolean isEmpty = true;
            if (x < recipe.getWidth() && y < recipe.getHeight() && (ingInputs = (ingredient = ingredients[x + y * recipe.getWidth()]).getInputs()).size() > 0) {
                if (ingredient.dictatesOutputType()) {
                    minimalInputStacks.add(ingInputs);
                    subtypeIndex = i;
                } else {
                    minimalInputStacks.add((Object)ImmutableList.of((Object)ingInputs.get(0)));
                }
                this.ingredientMatrix[i] = ingredient;
                allInputs.add(ingInputs);
                isEmpty = false;
            }
            if (!isEmpty) continue;
            ingredient = null;
            ImmutableList<ItemStack> stacks = null;
            boolean dictator = false;
            while (auxIdx < aux.length) {
                ImmutableList<ItemStack> a;
                if ((a = (ingredient = aux[auxIdx++]).getInputs()).size() <= 0) continue;
                stacks = a;
                if (!ingredient.dictatesOutputType()) break;
                subtypeIndex = i;
                dictator = true;
                break;
            }
            if (stacks == null) {
                stacks = ImmutableList.of();
                ingredient = null;
            }
            minimalInputStacks.add(stacks.isEmpty() || dictator ? stacks : ImmutableList.of((Object)stacks.get(0)));
            this.ingredientMatrix[i] = ingredient;
            allInputs.add(stacks);
        }
        this.allInputs = allInputs.build();
        this.minimalInputStacks = minimalInputStacks.build();
        this.subtypeIndex = subtypeIndex;
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.forOutputMatches((v, output) -> outputs.add(output));
        this.outputs = outputs.build();
    }

    private void forOutputMatches(BiConsumer<ItemStack, ItemStack> outputConsumer) {
        InventoryCrafting crafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }

            public void func_75130_a(IInventory inventory) {
            }
        }, this.getWidth(), this.getHeight());
        if (this.subtypeIndex == -1) {
            IngredientAuxiliary<?>[] aux = this.recipe.getAuxiliaryIngredients();
            boolean ai = false;
            for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                List stacks = (List)this.minimalInputStacks.get(i);
                crafting.func_70299_a(i, stacks.isEmpty() ? null : (ItemStack)stacks.get(0));
            }
            if (this.recipe.func_77569_a(crafting, null)) {
                outputConsumer.accept(null, this.recipe.func_77572_b(crafting));
            }
        } else {
            List dictators = (List)this.minimalInputStacks.get(this.subtypeIndex);
            for (ItemStack subtype : dictators) {
                crafting.func_174888_l();
                for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                    if (i == this.subtypeIndex) {
                        crafting.func_70299_a(i, subtype);
                        continue;
                    }
                    List stacks = (List)this.minimalInputStacks.get(i);
                    crafting.func_70299_a(i, stacks.isEmpty() ? null : (ItemStack)stacks.get(0));
                }
                if (!this.recipe.func_77569_a(crafting, null)) continue;
                outputConsumer.accept(subtype, this.recipe.func_77572_b(crafting));
            }
        }
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public Input getInputsForOutput(ItemStack output) {
        IngredientRegular[] ingredients = this.recipe.getIngredients();
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(9);
        Ingredient[] ingredientMat = new Ingredient[9];
        IngredientAuxiliary<?>[] aux = this.recipe.getAuxiliaryIngredients();
        int auxIngIdx = 0;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            ImmutableList<ImmutableList<ItemStack>> ingInputs;
            int x = i % 3;
            int y = i / 3;
            IngredientRegular ingredient = null;
            if (x < this.recipe.getWidth() && y < this.recipe.getHeight()) {
                ingredient = ingredients[x + y * this.recipe.getWidth()];
                ingInputs = ingredient.getInput(output);
            } else {
                ingInputs = null;
            }
            if (ingInputs == null || ingInputs.isEmpty()) {
                boolean isEmpty = true;
                if (auxIngIdx < aux.length) {
                    ImmutableList<ImmutableList<ItemStack>> auxInputs = null;
                    IngredientAuxiliary<?> ingredientAux = null;
                    while (auxIngIdx < aux.length && (auxInputs = (ingredientAux = aux[auxIngIdx]).getInput(output)).size() <= 0) {
                        ++auxIngIdx;
                    }
                    if (auxInputs != null && auxInputs.size() > 0) {
                        inputs.add((List<ItemStack>)auxInputs.get(auxIdx++));
                        ingredientMat[i] = ingredientAux;
                        if (auxIdx == auxInputs.size()) {
                            auxIdx = 0;
                            ++auxIngIdx;
                        }
                        isEmpty = false;
                    }
                }
                if (!isEmpty) continue;
                inputs.add(Collections.EMPTY_LIST);
                continue;
            }
            inputs.add((List<ItemStack>)ingInputs.get(0));
            ingredientMat[i] = ingredient;
        }
        return new Input(inputs, ingredientMat);
    }

    private Input getInputsForIngredient(ItemStack ingredient) {
        InventoryCrafting crafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }

            public void func_75130_a(IInventory inventory) {
            }
        }, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.allInputs.size(); ++i) {
            List options = (List)this.allInputs.get(i);
            ItemStack matched = null;
            for (ItemStack o : options) {
                if (ingredient.func_77973_b() != o.func_77973_b() || ingredient.func_77952_i() != o.func_77952_i()) continue;
                matched = ingredient.func_77946_l();
                matched.field_77994_a = 1;
                break;
            }
            if (matched == null) continue;
            crafting.func_174888_l();
            for (int n = 0; n < this.minimalInputStacks.size(); ++n) {
                List stacks = (List)this.minimalInputStacks.get(n);
                crafting.func_70299_a(n, (ItemStack)(i == n ? matched : (stacks.isEmpty() ? null : (ItemStack)stacks.get(0))));
            }
            if (!this.recipe.func_77569_a(crafting, null)) continue;
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(this.allInputs.size());
            for (int n = 0; n < this.allInputs.size(); ++n) {
                List stacks = (List)this.allInputs.get(n);
                List<Object> a = i == n ? Collections.singletonList(matched) : (stacks.isEmpty() ? Collections.singletonList(null) : (n == this.subtypeIndex ? Collections.singletonList(stacks.get(stacks.size() > 1 ? 1 : 0)) : stacks));
                inputs.add(a);
            }
            return new Input(inputs, this.ingredientMatrix);
        }
        return null;
    }

    public ItemStack getOutput(List<List<ItemStack>> inputs) {
        InventoryCrafting crafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }

            public void func_75130_a(IInventory inventory) {
            }
        }, this.getWidth(), this.getHeight());
        for (int i = 0; i < inputs.size(); ++i) {
            List<ItemStack> stacks = inputs.get(i);
            crafting.func_70299_a(i, stacks.isEmpty() ? null : stacks.get(0));
        }
        if (this.recipe.func_77569_a(crafting, null)) {
            return this.recipe.func_77572_b(crafting);
        }
        throw new IllegalStateException("Bad recipe generation which doesn't give output");
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.allInputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void setRecipe(IRecipeLayout layout, IIngredients ingredients) {
        IFocus focus = layout.getFocus();
        Object value = focus.getValue();
        IGuiItemStackGroup group = layout.getItemStacks();
        if (value instanceof ItemStack) {
            ItemStack stack = (ItemStack)value;
            Input input = null;
            input = focus.getMode() == IFocus.Mode.OUTPUT ? this.getInputsForOutput(stack) : this.getInputsForIngredient(stack);
            if (input != null) {
                ingredients.setInputLists(ItemStack.class, input.inputs);
                ingredients.setOutput(ItemStack.class, (Object)this.getOutput(input.inputs));
                group.addTooltipCallback((ITooltipCallback)new Tooltips(input.ingredients));
            }
        }
        group.set(ingredients);
    }

    private final class Tooltips
    implements ITooltipCallback<ItemStack> {
        Ingredient<?, ?>[] ingredients;

        public Tooltips(Ingredient<?, ?>[] ingredients) {
            this.ingredients = ingredients;
        }

        public void onTooltip(int slot, boolean input, ItemStack ingredient, List<String> tooltip) {
            if (!input) {
                return;
            }
            Ingredient<?, ?> ing = this.ingredients[slot - 1];
            if (ing != null) {
                ing.addTooltip(tooltip);
            }
        }
    }

    private final class Input {
        List<List<ItemStack>> inputs;
        Ingredient<?, ?>[] ingredients;

        public Input(List<List<ItemStack>> inputs, Ingredient<?, ?>[] ingredients) {
            this.inputs = inputs;
            this.ingredients = ingredients;
        }
    }
}

