/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.item;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.item.ItemConnection;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.server.item.crafting.Recipes;
import com.pau101.fairylights.util.Utils;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.translation.I18n;

public final class ItemConnectionHangingLights
extends ItemConnection {
    public ItemConnectionHangingLights() {
        this.func_77637_a(FairyLights.fairyLightsTab);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound.func_74767_n("twinkle")) {
            tooltip.add(I18n.func_74838_a((String)"item.fairyLights.twinkle"));
        }
        if (compound.func_74767_n("tight")) {
            tooltip.add(I18n.func_74838_a((String)"item.fairyLights.tight"));
        }
        if (compound.func_150297_b("pattern", 9)) {
            NBTTagList tagList = compound.func_150295_c("pattern", 10);
            int tagCount = tagList.func_74745_c();
            if (tagCount > 0) {
                tooltip.add(I18n.func_74838_a((String)"item.fairyLights.pattern"));
            }
            for (int i = 0; i < tagCount; ++i) {
                NBTTagCompound lightCompound = tagList.func_150305_b(i);
                String variant = I18n.func_74838_a((String)(FairyLights.light.func_77658_a() + '.' + LightVariant.getLightVariant(lightCompound.func_74762_e("light")).getUnlocalizedName() + ".name"));
                tooltip.add(I18n.func_74837_a((String)"format.pattern.entry", (Object[])new Object[]{Utils.formatColored(EnumDyeColor.func_176766_a((int)lightCompound.func_74771_c("color")), variant)}));
            }
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            subItems.add(Recipes.makeHangingLights(new ItemStack((Item)FairyLights.hangingLights), color));
        }
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.HANGING_LIGHTS;
    }
}

