/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.styledstring;

import com.google.common.base.Preconditions;
import com.pau101.fairylights.util.styledstring.StyledString;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.text.TextFormatting;

public final class Style {
    private final TextFormatting color;
    private final boolean isObfuscated;
    private final boolean isBold;
    private final boolean isStrikethrough;
    private final boolean isUnderline;
    private final boolean isItalic;

    public Style() {
        this(StyledString.DEFAULT_COLOR, new TextFormatting[0]);
    }

    public Style(TextFormatting color, TextFormatting ... fancy) {
        Preconditions.checkArgument((boolean)color.func_96302_c(), (Object)"Must be a color");
        this.color = color;
        if (fancy == null) {
            this.isItalic = false;
            this.isUnderline = false;
            this.isStrikethrough = false;
            this.isBold = false;
            this.isObfuscated = false;
        } else {
            boolean o = false;
            boolean b = false;
            boolean s = false;
            boolean u = false;
            boolean i = false;
            block7: for (TextFormatting f : fancy) {
                switch (f) {
                    case OBFUSCATED: {
                        o = true;
                        continue block7;
                    }
                    case BOLD: {
                        b = true;
                        continue block7;
                    }
                    case STRIKETHROUGH: {
                        s = true;
                    }
                    case UNDERLINE: {
                        u = true;
                        continue block7;
                    }
                    case ITALIC: {
                        i = true;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot use non-fancy formatting");
                    }
                }
            }
            this.isObfuscated = o;
            this.isBold = b;
            this.isStrikethrough = s;
            this.isUnderline = u;
            this.isItalic = i;
        }
    }

    public Style(TextFormatting color, boolean isBold, boolean isStrikethrough, boolean isUnderline, boolean isItalic, boolean isObfuscated) {
        Preconditions.checkArgument((boolean)color.func_96302_c(), (Object)"Must be a color");
        this.color = color;
        this.isBold = isBold;
        this.isStrikethrough = isStrikethrough;
        this.isUnderline = isUnderline;
        this.isItalic = isItalic;
        this.isObfuscated = isObfuscated;
    }

    public Style(short style) {
        this.color = Style.getColorFromStyle(style);
        this.isObfuscated = (style & 0x10) != 0;
        this.isBold = (style & 0x20) != 0;
        this.isStrikethrough = (style & 0x40) != 0;
        this.isUnderline = (style & 0x80) != 0;
        this.isItalic = (style & 0x100) != 0;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public boolean isObfuscated() {
        return this.isObfuscated;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isStrikethrough() {
        return this.isStrikethrough;
    }

    public boolean isUnderline() {
        return this.isUnderline;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isPlain() {
        return !this.isObfuscated && !this.isBold && !this.isStrikethrough && !this.isUnderline && !this.isItalic;
    }

    public short getValue() {
        return Style.getShortStyling(this.color, this.isBold, this.isStrikethrough, this.isUnderline, this.isItalic);
    }

    public Style withColor(TextFormatting color) {
        Preconditions.checkArgument((boolean)color.func_96302_c(), (Object)"Must be color");
        return new Style(color, this.isBold, this.isStrikethrough, this.isUnderline, this.isItalic, this.isObfuscated);
    }

    public Style withBold(boolean isBold) {
        return new Style(this.color, isBold, this.isStrikethrough, this.isUnderline, this.isItalic, this.isObfuscated);
    }

    public Style withStrikethrough(boolean isStrikethrough) {
        return new Style(this.color, this.isBold, isStrikethrough, this.isUnderline, this.isItalic, this.isObfuscated);
    }

    public Style withUnderline(boolean isUnderline) {
        return new Style(this.color, this.isBold, this.isStrikethrough, isUnderline, this.isItalic, this.isObfuscated);
    }

    public Style withItalic(boolean isItalic) {
        return new Style(this.color, this.isBold, this.isStrikethrough, this.isUnderline, isItalic, this.isObfuscated);
    }

    public Style withObfuscated(boolean isObfuscated) {
        return new Style(this.color, this.isBold, this.isStrikethrough, this.isUnderline, this.isItalic, isObfuscated);
    }

    public Style withStyling(TextFormatting styling, boolean state) {
        Preconditions.checkArgument((styling != TextFormatting.RESET ? 1 : 0) != 0, (Object)"Reset is not styling");
        if (styling.func_96302_c()) {
            return this.withColor(styling);
        }
        boolean b = this.isBold;
        boolean s = this.isStrikethrough;
        boolean u = this.isUnderline;
        boolean i = this.isItalic;
        boolean o = this.isObfuscated;
        switch (styling) {
            case BOLD: {
                b = state;
                break;
            }
            case STRIKETHROUGH: {
                s = state;
                break;
            }
            case UNDERLINE: {
                u = state;
                break;
            }
            case ITALIC: {
                i = state;
                break;
            }
            case OBFUSCATED: {
                o = state;
                break;
            }
        }
        return new Style(this.color, b, s, u, i, o);
    }

    public int hashCode() {
        int h = this.color.hashCode();
        h = 31 * h + (this.isBold ? 1231 : 1237);
        h = 31 * h + (this.isItalic ? 1231 : 1237);
        h = 31 * h + (this.isObfuscated ? 1231 : 1237);
        h = 31 * h + (this.isStrikethrough ? 1231 : 1237);
        h = 31 * h + (this.isUnderline ? 1231 : 1237);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Style) {
            Style other = (Style)obj;
            if (this.color != other.color) {
                return false;
            }
            if (this.isBold != other.isBold) {
                return false;
            }
            if (this.isItalic != other.isItalic) {
                return false;
            }
            if (this.isObfuscated != other.isObfuscated) {
                return false;
            }
            if (this.isStrikethrough != other.isStrikethrough) {
                return false;
            }
            if (this.isUnderline != other.isUnderline) {
                return false;
            }
        }
        return true;
    }

    public static final TextFormatting getColorFromStyle(short style) {
        return TextFormatting.values()[style & 0xF];
    }

    public static final short getStylingAsShort(TextFormatting ... styling) {
        TextFormatting color = null;
        int value = 0;
        for (TextFormatting style : styling) {
            if (style.func_96302_c()) {
                color = style;
                continue;
            }
            if (!style.func_96301_b()) continue;
            value = (short)(value | 1 << 4 + style.ordinal() - 16);
        }
        if (color == null) {
            color = StyledString.DEFAULT_COLOR;
        }
        return (short)(value | color.ordinal());
    }

    public static final Set<TextFormatting> getFancyStylingFromStyle(short style) {
        HashSet<TextFormatting> fancy = new HashSet<TextFormatting>();
        TextFormatting[] formatting = TextFormatting.values();
        int field = style >> 4 & 0x1F;
        for (int i = 0; i < 5; ++i) {
            if ((field & 1 << i) == 0) continue;
            fancy.add(formatting[16 + i]);
        }
        return fancy;
    }

    public static final short getShortStyling(TextFormatting color, boolean isBold, boolean isStrikethrough, boolean isUnderline, boolean isItalic) {
        short style = (short)color.ordinal();
        if (isBold) {
            style = (short)(style | 0x20);
        }
        if (isStrikethrough) {
            style = (short)(style | 0x40);
        }
        if (isUnderline) {
            style = (short)(style | 0x80);
        }
        if (isItalic) {
            style = (short)(style | 0x100);
        }
        return style;
    }

    public static final boolean hasStyling(short style, TextFormatting formatting) {
        if (formatting.func_96302_c()) {
            return (style & 0xF) == formatting.ordinal();
        }
        if (formatting.func_96301_b()) {
            return (style >> 4 & 0x1F & 1 << formatting.ordinal() - 16) != 0;
        }
        return false;
    }
}

