/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants;

import com.flashfyre.ffenchants.enchantments.BloodlustEnchantment;
import com.flashfyre.ffenchants.enchantments.PillagingEnchantment;
import com.flashfyre.ffenchants.enchantments.PoisonAspectEnchantment;
import com.flashfyre.ffenchants.enchantments.SearingEnchantment;
import com.flashfyre.ffenchants.enchantments.SharpshooterEnchantment;
import com.flashfyre.ffenchants.enchantments.SteadfastEnchantment;
import com.flashfyre.ffenchants.enchantments.TorrentEnchantment;
import com.flashfyre.ffenchants.enchantments.VampiricEnchantment;
import com.flashfyre.ffenchants.enchantments.WeightedEnchantment;
import com.flashfyre.ffenchants.enchantments.WitherAspectEnchantment;
import com.flashfyre.ffenchants.misc.Config;
import com.flashfyre.ffenchants.misc.IShooterEnchantments;
import com.flashfyre.ffenchants.misc.ShooterEnchantments;
import com.flashfyre.ffenchants.misc.ShooterEnchantmentsStorage;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="ffenchants")
public class FFEnchantments {
    public static FFEnchantments instance;
    public static final String MOD_ID = "ffenchants";
    public static final Logger LOGGER;
    private static final EquipmentSlotType[] ARMOUR_SLOTS;
    @ObjectHolder(value="ffenchants:bloodlust")
    public static Enchantment BLOODLUST;
    @ObjectHolder(value="ffenchants:vampiric")
    public static Enchantment VAMPIRIC;
    @ObjectHolder(value="ffenchants:weighted")
    public static Enchantment WEIGHTED;
    @ObjectHolder(value="ffenchants:poison_aspect")
    public static Enchantment POISON_ASPECT;
    @ObjectHolder(value="ffenchants:wither_aspect")
    public static Enchantment WITHER_ASPECT;
    @ObjectHolder(value="ffenchants:pillaging")
    public static Enchantment PILLAGING;
    @ObjectHolder(value="ffenchants:searing")
    public static Enchantment SEARING;
    @ObjectHolder(value="ffenchants:steadfast")
    public static Enchantment STEADFAST;
    @ObjectHolder(value="ffenchants:torrent")
    public static Enchantment TORRENT;
    @ObjectHolder(value="ffenchants:sharpshooter")
    public static Enchantment SHARPSHOOTER;

    public FFEnchantments() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.CONFIG);
        Config.loadConfig(Config.CONFIG, FMLPaths.CONFIGDIR.get().resolve("ffenchants.toml").toString());
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        LOGGER.info("Registering FFE Enchantments.");
        IForgeRegistry registry = event.getRegistry();
        BLOODLUST = new BloodlustEnchantment(Enchantment.Rarity.RARE, EnchantmentType.ALL, EquipmentSlotType.MAINHAND);
        VAMPIRIC = new VampiricEnchantment(Enchantment.Rarity.VERY_RARE, EnchantmentType.WEAPON, EquipmentSlotType.MAINHAND);
        WEIGHTED = new WeightedEnchantment(Enchantment.Rarity.UNCOMMON, EnchantmentType.WEAPON, EquipmentSlotType.MAINHAND);
        POISON_ASPECT = new PoisonAspectEnchantment(Enchantment.Rarity.RARE, EnchantmentType.WEAPON, EquipmentSlotType.MAINHAND);
        WITHER_ASPECT = new WitherAspectEnchantment(Enchantment.Rarity.VERY_RARE, EnchantmentType.WEAPON, EquipmentSlotType.MAINHAND);
        PILLAGING = new PillagingEnchantment(Enchantment.Rarity.UNCOMMON, EnchantmentType.CROSSBOW, EquipmentSlotType.MAINHAND);
        SEARING = new SearingEnchantment(Enchantment.Rarity.UNCOMMON, EnchantmentType.ARMOR_CHEST, ARMOUR_SLOTS);
        STEADFAST = new SteadfastEnchantment(Enchantment.Rarity.UNCOMMON, EnchantmentType.ARMOR_CHEST, EquipmentSlotType.CHEST);
        TORRENT = new TorrentEnchantment(Enchantment.Rarity.RARE, EnchantmentType.TRIDENT, EquipmentSlotType.MAINHAND);
        SHARPSHOOTER = new SharpshooterEnchantment(Enchantment.Rarity.RARE, EnchantmentType.CROSSBOW, EquipmentSlotType.MAINHAND);
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, BLOODLUST, (Boolean)Config.enableBloodlust.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, VAMPIRIC, (Boolean)Config.enableVampiric.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, PILLAGING, (Boolean)Config.enablePillaging.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, WEIGHTED, (Boolean)Config.enableWeighted.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, POISON_ASPECT, (Boolean)Config.enablePoisonAspect.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, WITHER_ASPECT, (Boolean)Config.enableWitherAspect.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, SEARING, (Boolean)Config.enableSearing.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, STEADFAST, (Boolean)Config.enableSteadfast.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, TORRENT, (Boolean)Config.enableTorrent.get());
        FFEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)registry, SHARPSHOOTER, (Boolean)Config.enableSharpshooter.get());
    }

    public static void registerEnchantment(IForgeRegistry<Enchantment> registry, Enchantment enchantment, boolean enabledInConfig) {
        if (enabledInConfig) {
            registry.register((IForgeRegistryEntry)enchantment);
            LOGGER.info("Registered enchantment " + enchantment.getRegistryName() + ".");
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IShooterEnchantments.class, (Capability.IStorage)new ShooterEnchantmentsStorage(), ShooterEnchantments::new);
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
        ARMOUR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
        BLOODLUST = null;
        VAMPIRIC = null;
        WEIGHTED = null;
        POISON_ASPECT = null;
        WITHER_ASPECT = null;
        PILLAGING = null;
        SEARING = null;
        STEADFAST = null;
        TORRENT = null;
        SHARPSHOOTER = null;
    }
}

