/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.enchantments;

import com.flashfyre.ffenchants.FFEnchantments;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ffenchants")
public class SteadfastEnchantment
extends Enchantment {
    public static DamageSource steadfastDamageSource = new DamageSource("steadfastKnockback").func_82726_p().func_151518_m();

    public SteadfastEnchantment(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        this.setRegistryName("ffenchants", "steadfast");
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10 + 20 * (enchantmentLevel - 1);
    }

    public int func_223551_b(int p_223551_1_) {
        return super.func_77321_a(p_223551_1_) + 50;
    }

    @SubscribeEvent
    public static void reduceKnockback(LivingKnockBackEvent event) {
        ItemStack stack;
        LivingEntity target = event.getEntityLiving();
        if (target instanceof FakePlayer) {
            return;
        }
        float originalStrength = event.getStrength();
        float strength = event.getStrength();
        if (originalStrength < 0.0f) {
            event.setStrength(strength *= -1.0f);
        }
        if ((stack = target.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b()) {
            return;
        }
        float level = EnchantmentHelper.func_77506_a((Enchantment)FFEnchantments.STEADFAST, (ItemStack)stack);
        if (level > 0.0f) {
            float newStrength = strength - level / 10.0f;
            event.setStrength(newStrength);
            if (originalStrength < 0.0f) {
                return;
            }
            if (event.getAttacker() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)event.getAttacker();
                double x = target.field_70165_t - attacker.field_70165_t;
                double z = target.field_70161_v - attacker.field_70161_v;
                while (x * x + z * z < 1.0E-4) {
                    x = (Math.random() - Math.random()) * 0.01;
                    z = (Math.random() - Math.random()) * 0.01;
                }
                attacker.func_70653_a(event.getEntity(), level / -10.0f, x, z);
            }
        }
    }
}

