/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.misc;

import com.flashfyre.ffenchants.FFEnchantments;
import com.flashfyre.ffenchants.enchantments.SharpshooterEnchantment;
import com.flashfyre.ffenchants.misc.ShooterEnchantmentsProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ffenchants")
public class CapabilityEventHandler {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof AbstractArrowEntity) {
            event.addCapability(new ResourceLocation("ffenchants", "shooterinfo"), (ICapabilityProvider)new ShooterEnchantmentsProvider());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrow;
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (event.getEntity() instanceof AbstractArrowEntity && (arrow = (AbstractArrowEntity)event.getEntity()).func_212360_k() instanceof LivingEntity) {
            arrow.getCapability(ShooterEnchantmentsProvider.SHOOTER_INFO_CAPABILITY).ifPresent(data -> {
                int sharpshooterLevel;
                int torrentLevel;
                LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
                ItemStack item = shooter.func_184586_b(Hand.MAIN_HAND);
                int pillagingLevel = EnchantmentHelper.func_77506_a((Enchantment)FFEnchantments.PILLAGING, (ItemStack)item);
                if (pillagingLevel > 0 && !data.hasEnchantment(FFEnchantments.PILLAGING)) {
                    data.addEnchantment(FFEnchantments.PILLAGING, pillagingLevel);
                }
                if ((torrentLevel = EnchantmentHelper.func_77506_a((Enchantment)FFEnchantments.TORRENT, (ItemStack)item)) > 0 && !data.hasEnchantment(FFEnchantments.TORRENT)) {
                    data.addEnchantment(FFEnchantments.TORRENT, torrentLevel);
                }
                if ((sharpshooterLevel = EnchantmentHelper.func_77506_a((Enchantment)FFEnchantments.SHARPSHOOTER, (ItemStack)item)) > 0 && !data.hasEnchantment(FFEnchantments.SHARPSHOOTER)) {
                    data.addEnchantment(FFEnchantments.SHARPSHOOTER, sharpshooterLevel);
                    SharpshooterEnchantment.setNewVelocity(shooter, arrow, sharpshooterLevel);
                }
            });
        }
    }
}

