/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.enchantments;

import com.flashfyre.ffenchants.FFEnchantments;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ffenchants")
public class BloodlustEnchantment
extends Enchantment {
    public BloodlustEnchantment(Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
        this.setRegistryName("ffenchants", "bloodlust");
    }

    public int func_77325_b() {
        return 2;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + 20 * (enchantmentLevel - 1);
    }

    public int func_223551_b(int enchantmentLevel) {
        return super.func_223551_b(enchantmentLevel) + 50;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof AxeItem || stack.func_77973_b() instanceof SwordItem;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof AxeItem;
    }

    @SubscribeEvent
    public static void applyStrengthOnKill(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source == null || source.func_76346_g() == null) {
            return;
        }
        if (source.func_76346_g() instanceof LivingEntity) {
            LivingEntity user = (LivingEntity)source.func_76346_g();
            if (user instanceof FakePlayer) {
                return;
            }
            ItemStack heldItem = user.func_184586_b(Hand.MAIN_HAND);
            int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)FFEnchantments.BLOODLUST, (ItemStack)heldItem);
            if (enchLevel > 0) {
                int strengthLevel = 0;
                if (user.func_70644_a(Effects.field_76420_g)) {
                    strengthLevel = user.func_70660_b(Effects.field_76420_g).func_76458_c() + 1;
                }
                strengthLevel = Math.min(strengthLevel, 1 + enchLevel);
                user.func_195064_c(new EffectInstance(Effects.field_76420_g, 80 + (60 * enchLevel - 1), strengthLevel, false, true));
            }
        }
    }
}

