/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.enchantments;

import com.flashfyre.ffenchants.FFEnchantments;
import com.flashfyre.ffenchants.capability.SteadfastHandlerProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ffenchants")
public class SteadfastEnchantment
extends Enchantment {
    public SteadfastEnchantment(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        this.setRegistryName("ffenchants", "steadfast");
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 10 + 20 * (level - 1);
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    @SubscribeEvent
    public static void reduceKnockback(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target instanceof FakePlayer) {
            return;
        }
        target.getCapability(SteadfastHandlerProvider.STEADFAST_HANDLER_CAPABILITY).ifPresent(targetData -> {
            int level;
            boolean steadfastHandled = targetData.getSteadfastHandled();
            if (steadfastHandled) {
                targetData.setSteadfastHandled(false);
            }
            if ((level = FFEnchantments.getEnchantmentLevel(target.func_184582_a(EquipmentSlotType.CHEST), FFEnchantments.STEADFAST)) > 0) {
                float strength = event.getStrength();
                float newStrength = strength - (float)level / 10.0f;
                event.setStrength(newStrength);
                if (steadfastHandled) {
                    return;
                }
                if (event.getAttacker() instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)event.getAttacker();
                    attacker.getCapability(SteadfastHandlerProvider.STEADFAST_HANDLER_CAPABILITY).ifPresent(attackerData -> {
                        attackerData.setSteadfastHandled(true);
                        attacker.field_70133_I = true;
                        attacker.func_70653_a((Entity)target, 0.4f, target.func_226277_ct_() - attacker.func_226277_ct_(), target.func_226281_cx_() - attacker.func_226281_cx_());
                        System.out.println("attacker should be knocked back");
                    });
                }
            }
        });
    }
}

