/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.enchantments;

import com.flashfyre.ffenchants.FFEnchantments;
import com.flashfyre.ffenchants.capability.ShooterEnchantmentsProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ffenchants")
public class TorrentEnchantment
extends Enchantment {
    public TorrentEnchantment(Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
        this.setRegistryName("ffenchants", "torrent");
    }

    public int func_77325_b() {
        return 5;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1 + (enchantmentLevel - 1) * 8;
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 20;
    }

    public boolean func_92089_a(ItemStack stack) {
        return super.func_92089_a(stack);
    }

    @SubscribeEvent
    public static void damageFireEntities(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target.func_70045_F()) {
            if (event.getSource().func_76364_f() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)event.getSource().func_76364_f();
                int level = FFEnchantments.getEnchantmentLevel(attacker.func_184586_b(Hand.MAIN_HAND), FFEnchantments.TORRENT);
                if (level > 0) {
                    event.setAmount((float)level * 2.5f + event.getAmount());
                    TorrentEnchantment.doExtraEffects(attacker, target);
                }
            } else if (event.getSource().func_76364_f() instanceof TridentEntity) {
                TridentEntity trident = (TridentEntity)event.getSource().func_76364_f();
                if (event.getSource().func_76346_g() instanceof LivingEntity) {
                    LivingEntity thrower = (LivingEntity)event.getSource().func_76346_g();
                    trident.getCapability(ShooterEnchantmentsProvider.SHOOTER_INFO_CAPABILITY).ifPresent(data -> {
                        if (data.hasEnchantment(FFEnchantments.TORRENT)) {
                            int level = data.getEnchantments().get(FFEnchantments.TORRENT);
                            event.setAmount((float)level * 2.5f + event.getAmount());
                            TorrentEnchantment.doExtraEffects(thrower, target);
                        }
                    });
                }
            }
        }
    }

    public static void doExtraEffects(LivingEntity attacker, LivingEntity target) {
        World world;
        if (target.func_70027_ad()) {
            target.func_70066_B();
        }
        if (!(world = attacker.field_70170_p).func_201670_d()) {
            if (attacker instanceof PlayerEntity) {
                world.func_184133_a(null, target.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.MASTER, 1.0f, 1.0f);
            }
            ServerWorld serverWorld = (ServerWorld)world;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_218422_X, (double)target.func_180425_c().func_177958_n() + 0.5, (double)target.func_180425_c().func_177956_o() + 0.75, (double)target.func_180425_c().func_177952_p() + 0.5, 24, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

